/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.taglib.app;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.marketsim.bo.operator.Operator;
import ar.com.sdd.marketsim.csrf.AntiCSRFTokenManager;
import ar.com.sdd.marketsim.session.APPSession;
import ar.com.sdd.marketsim.session.http.HTTPSessionManager;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class InitJSP
extends TagSupport {
    private static final Logger log = LogManager.getLogger(InitJSP.class);
    private String tag = "";
    private APPSession.SessionRequirement sessionRequired = APPSession.SessionRequirement.TRUE;
    private Boolean validateCSRF = false;

    public InitJSP() {
    }

    public InitJSP(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public APPSession.SessionRequirement getSessionRequired() {
        return this.sessionRequired;
    }

    public void setSessionRequired(APPSession.SessionRequirement sessionRequired) {
        this.sessionRequired = sessionRequired;
    }

    public Boolean getValidateCSRF() {
        return this.validateCSRF;
    }

    public void setValidateCSRF(Boolean validateCSRF) {
        this.validateCSRF = validateCSRF;
    }

    public int doEndTag() throws JspException {
        Operator operator;
        HttpSession session;
        HttpServletRequest request;
        HttpServletResponse response;
        block23: {
            AntiCSRFTokenManager tokenManager;
            if (this.pageContext == null) {
                throw new ApplicationException("pageContext null");
            }
            response = (HttpServletResponse)this.pageContext.getResponse();
            request = (HttpServletRequest)this.pageContext.getRequest();
            session = this.pageContext.getSession();
            APPSession appSession = APPSession.getFrom(request);
            if (appSession == null && this.validateCSRF != null && this.validateCSRF.booleanValue()) {
                throw new ApplicationException("AppSession null");
            }
            String token = (String)request.getAttribute("CSRFToken");
            if (StringUtil.isNotEmpty((String)token)) {
                request.removeAttribute("CSRFToken");
            } else {
                token = request.getParameter("CSRFToken");
            }
            if (StringUtil.isEmpty((String)token)) {
                if (this.validateCSRF != null && this.validateCSRF.booleanValue()) {
                    log.warn("No se envio el token o esta vacio");
                    throw new ApplicationException("page.CSRFFail");
                }
            } else if (appSession == null) {
                tokenManager = APPSession.getAntiCSRFTokenManagerNoSession();
                if (this.validateCSRF != null) {
                    if (this.validateCSRF.booleanValue()) {
                        tokenManager.validateToken(token);
                    } else {
                        tokenManager.checkToken(token);
                    }
                }
            } else {
                tokenManager = appSession.getAntiCSRFTokenManager();
                if (this.validateCSRF != null) {
                    if (this.validateCSRF.booleanValue()) {
                        tokenManager.validateToken(token);
                    } else {
                        tokenManager.checkToken(token);
                    }
                }
            }
            if (this.sessionRequired == APPSession.SessionRequirement.TRUE) {
                try {
                    if (session.isNew()) {
                        log.debug("Session timeout");
                        throw new ApplicationException("invalid.session.timeout");
                    }
                    break block23;
                }
                catch (Exception e) {
                    throw new ApplicationException("invalid.session.timeout");
                }
            }
            if (this.sessionRequired == APPSession.SessionRequirement.REQUIRESNEW) {
                HTTPSessionManager sessionManager = new HTTPSessionManager();
                sessionManager.invalidateHTTPSession(session, request, response);
            }
        }
        if ((operator = (Operator)session.getAttribute("operator")) != null && !operator.isEnabled()) {
            log.warn("El operador {} esta bloqueado. Se invalida la sesion", (Object)operator);
            HTTPSessionManager sessionManager = new HTTPSessionManager();
            sessionManager.invalidateHTTPSession(session, request, response);
            throw new ApplicationException("page.operator.not.enabled");
        }
        JspWriter out = this.pageContext.getOut();
        try {
            out.write("<!DOCTYPE html>\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return super.doEndTag();
    }

    public void release() {
        super.release();
        this.tag = "";
        this.sessionRequired = APPSession.SessionRequirement.TRUE;
        this.validateCSRF = false;
    }
}

