package ar.com.sdd.marketsimapi.api.auth;

import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.util.Base64;

/**
 * Endpoint para la autenticación del servicio cliente (no del usuario final).
 * Este endpoint valida credenciales del servicio y retorna un token que deberá
 * ser enviado luego en /login y /dll.
 */
@Path("/auth")
public class MksApiAuthEndpoint implements MksApiAuthService {

    @POST
    @Path("/token")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response generateToken(ServiceAuthRequest request, @Context SecurityContext securityContext) {
        // Validación del servicio (HARDCODEADA por ahora)
        if ("api-client".equals(request.getClientId()) && "client-secret-123".equals(request.getClientSecret())) {
            String tokenRaw = request.getClientId() + ":authorized";
            String token = Base64.getEncoder().encodeToString(tokenRaw.getBytes());

            String jsonResponse = String.format(
                    "{\"token\": \"%s\", \"expiresIn\": %d, \"type\": \"SERVICE\"}", token, 3600
            );

            return Response.ok(jsonResponse).build();
        } else {
            return Response.status(Response.Status.UNAUTHORIZED)
                    .entity("{\"error\": \"Credenciales de servicio inválidas\"}")
                    .build();
        }
    }

    /**
     * Clase que representa las credenciales del servicio cliente
     */
    public static class ServiceAuthRequest {
        private String clientId;
        private String clientSecret;

        public ServiceAuthRequest() {}

        public String getClientId() {
            return clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }
    }
}
