package ar.com.sdd.marketsimapi.api.command;

import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.util.Base64;

@Path("/command")
public class MksApiCommandEndpoint implements MksApiCommandService {

    @POST
    @Path("/execute")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    @Override
    public Response executeCommand(CommandRequest request,
                                   @Context SecurityContext securityContext,
                                   @HeaderParam("Authorization") String authHeader) {

        // Validación de token OAuth
        if (!isValidOAuthToken(authHeader)) {
            return Response.status(Response.Status.UNAUTHORIZED)
                    .entity("{\"error\": \"Token inválido\"}")
                    .build();
        }

        // Validación básica de userId
        if (!"abc123".equals(request.getUserId())) {
            return Response.status(Response.Status.UNAUTHORIZED)
                    .entity("{\"error\": \"Usuario no autorizado\"}")
                    .build();
        }

        // Simulación de ejecución del comando (acá podrías delegar a una DLL real)
        String command = request.getCommand();
        String simulatedLog = simulateCommandExecution(command);

        String jsonResponse = String.format(
                "{\"userId\": \"%s\", \"command\": \"%s\", \"log\": \"%s\"}",
                request.getUserId(),
                command,
                simulatedLog.replace("\"", "\\\"")  // escapamos comillas para JSON válido
        );

        return Response.ok(jsonResponse).build();
    }

    public static class CommandRequest {
        private String userId;
        private String command;

        public CommandRequest() {}

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getCommand() {
            return command;
        }

        public void setCommand(String command) {
            this.command = command;
        }
    }

    private boolean isValidOAuthToken(String authHeader) {
        if (authHeader == null || !authHeader.startsWith("OAuth ")) {
            return false;
        }

        String token = authHeader.substring("OAuth ".length()).trim();
        try {
            String decoded = new String(Base64.getDecoder().decode(token));
            return decoded.equals("api-client:authorized");
        } catch (IllegalArgumentException e) {
            return false;
        }
    }

    // Simulación simple (luego podés integrar con una DLL real)
    private String simulateCommandExecution(String command) {
        // Lógica mockeada
        if ("PING".equalsIgnoreCase(command)) {
            return "Comando recibido: PING\nRespuesta: PONG";
        } else if ("HELLO".equalsIgnoreCase(command)) {
            return "Comando recibido: HELLO\nRespuesta: Hello there!";
        } else {
            return "Comando recibido: " + command + "\nRespuesta: [Comando ejecutado correctamente]";
        }
    }
}
