/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsimapi.api.command;

import ar.com.sdd.marketsimapi.api.command.MksApiCommandService;
import java.util.Base64;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/command")
public class MksApiCommandEndpoint
implements MksApiCommandService {
    @Override
    @POST
    @Path(value="/execute")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeCommand(CommandRequest request, @Context SecurityContext securityContext, @HeaderParam(value="Authorization") String authHeader) {
        if (!this.isValidOAuthToken(authHeader)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"{\"error\": \"Token inv\u00e1lido\"}").build();
        }
        if (!"abc123".equals(request.getUserId())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"{\"error\": \"Usuario no autorizado\"}").build();
        }
        String command = request.getCommand();
        String simulatedLog = this.simulateCommandExecution(command);
        String jsonResponse = String.format("{\"userId\": \"%s\", \"command\": \"%s\", \"log\": \"%s\"}", request.getUserId(), command, simulatedLog.replace("\"", "\\\""));
        return Response.ok((Object)jsonResponse).build();
    }

    private boolean isValidOAuthToken(String authHeader) {
        if (authHeader == null || !authHeader.startsWith("OAuth ")) {
            return false;
        }
        String token = authHeader.substring("OAuth ".length()).trim();
        try {
            String decoded = new String(Base64.getDecoder().decode(token));
            return decoded.equals("api-client:authorized");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private String simulateCommandExecution(String command) {
        if ("PING".equalsIgnoreCase(command)) {
            return "Comando recibido: PING\nRespuesta: PONG";
        }
        if ("HELLO".equalsIgnoreCase(command)) {
            return "Comando recibido: HELLO\nRespuesta: Hello there!";
        }
        return "Comando recibido: " + command + "\nRespuesta: [Comando ejecutado correctamente]";
    }

    public static class CommandRequest {
        private String userId;
        private String command;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }
    }
}

