package ar.com.sdd.marketsimapi.api.auth;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.*;

@Path("/auth")
public class MksApiAuthEndpoint {

    @Inject
    private MksApiAuthService authService;

    @POST
    @ServerFileLogged
    @Path("/token.oauth2")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response postTokenOauth2(OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        return authService.postTokenOauth2(oauthCredentials, securityContext);
    }

    @POST
    @Path("/ping")
    @Produces(MediaType.TEXT_PLAIN)
    public String ping() {
        return "pong";
    }
}
