package ar.com.sdd.marketsimapi.api.login;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.util.Base64;

@Path("/login")
public class MksApiLoginEndpoint {

    @Inject
    private MksApiLoginService loginService;

    @POST
    @ServerFileLogged
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response postLogin(MksApiLoginModel request, @Context SecurityContext securityContext, @HeaderParam("Authorization") String authHeader) {
        return loginService.postLogin(request, securityContext, authHeader);
    }
}

//    @POST
//    @Consumes(MediaType.APPLICATION_JSON)
//    @Produces(MediaType.APPLICATION_JSON)
//    @Override
//    public Response loginoUser(UserLoginRequest request,
//                              @Context SecurityContext securityContext,
//                              @HeaderParam("Authorization") String authHeader) {
//
//        // Validación de token OAuth
//        if (!isValidOAuthToken(authHeader)) {
//            return Response.status(Response.Status.UNAUTHORIZED)
//                    .entity("{\"error\": \"Token OAuth inválido o faltante\"}")
//                    .build();
//        }
//
//        // Validación dummy del usuario (puede reemplazarse con DB en el futuro)
//        if ("userweb".equals(request.getUsername()) && "webpass123".equals(request.getPassword())) {
//            String userId = "abc123"; // Valor simulado
//
//            return Response.ok("{\"userId\": \"" + userId + "\"}").build();
//        } else {
//            return Response.status(Response.Status.UNAUTHORIZED)
//                    .entity("{\"error\": \"Usuario o contraseña inválidos\"}")
//                    .build();
//        }
//    }
//
//    private boolean isValidOAuthToken(String authHeader) {
//        if (authHeader == null || !authHeader.startsWith("OAuth ")) {
//            return false;
//        }
//
//        String token = authHeader.substring("OAuth ".length()).trim();
//        try {
//            String decoded = new String(Base64.getDecoder().decode(token));
//            return decoded.equals("api-client:authorized");
//        } catch (IllegalArgumentException e) {
//            return false;
//        }
//    }

