package ar.com.sdd.marketsimapi.api.login;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.util.Base64;

@Path("/login")
public class MksApiLoginEndpoint {

    @Inject
    private MksApiLoginService loginService;

    @POST
    @ServerFileLogged
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response postLogin(MksApiLoginModel request,
                              @Context SecurityContext securityContext,
                              @HeaderParam("Authorization") String authHeader) {
        return loginService.postLogin(request, securityContext, authHeader);
    }
}
