package ar.com.sdd.marketsimapi.api.auth;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.*;

@Path("/auth")
public class MksApiAuthEndpoint {

    @Inject
    private MksApiAuthService authService;

    @POST
    @ServerFileLogged
    @Path("/token.oauth2")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response postTokenOauth2(MksApiAuthModel authCredentials, @Context SecurityContext securityContext) {
        return authService.postTokenOauth2(authCredentials, securityContext);
    }
}
