package ar.com.sdd.marketsimapi.api.command;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.util.Base64;

@Path("/command")
public class MksApiCommandEndpoint {

    @Inject
    private MksApiCommandService commandService;

    @POST
    @ServerFileLogged
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response postCommand(MksApiCommandModel request,
                                @Context SecurityContext securityContext,
                                @HeaderParam("Authorization") String authHeader) {
        return commandService.postCommand(request, securityContext, authHeader);
    }
}
