/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.marketsim.bo.operator.OperatorHome;
import ar.com.sdd.marketsim.exception.NotInitializedException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HomeManager {
    private static final Logger log = LogManager.getLogger(HomeManager.class);
    private InitialContext ctx;
    private OperatorHome operatorHome = null;
    private static HomeManager instance = null;
    private static boolean initialized = false;

    public InitialContext getCtx() {
        return this.ctx;
    }

    public void setCtx(InitialContext ctx) {
        this.ctx = ctx;
    }

    public static HomeManager initialize(HomeManager homeManager) {
        try {
            homeManager.setCtx(new InitialContext());
            HomeManager.setInstance(homeManager);
            return instance;
        }
        catch (NamingException e) {
            log.error("No se pudo inicializar el contexto JNDI en HomeManager", (Throwable)e);
            return null;
        }
        catch (Exception ex) {
            log.error("Problemas al inicializar homeManager", (Throwable)ex);
            return null;
        }
    }

    public static HomeManager reinitialize() {
        HomeManager otherHomeManager;
        if (!initialized) {
            throw new NotInitializedException(HomeManager.class);
        }
        try {
            otherHomeManager = (HomeManager)instance.getClass().newInstance();
        }
        catch (Exception e) {
            log.error("Reinicializando el classManager. No se reinicializa");
            log.error("Ha ocurrido un error", (Throwable)e);
            throw new NotInitializedException(HomeManager.class);
        }
        instance = null;
        return HomeManager.initialize(otherHomeManager);
    }

    public static HomeManager getInstance() {
        if (!initialized) {
            throw new NotInitializedException(HomeManager.class);
        }
        return instance;
    }

    public static void setInstance(HomeManager homeManager) {
        instance = homeManager;
        initialized = true;
    }

    protected <T> T getHome(Context initialContext, String name, Class<T> clazz) throws ApplicationException {
        try {
            Object lookupResult = initialContext.lookup(name);
            return clazz.cast(lookupResult);
        }
        catch (ClassCastException e) {
            throw new ApplicationException("Failed to cast the object returned from JNDI lookup to the specified class.", (Throwable)e);
        }
        catch (Throwable e) {
            throw new ApplicationException(e);
        }
    }

    public <T> T getHome(String name, Class<T> clazz) throws ApplicationException {
        return this.getHome(this.getCtx(), name, clazz);
    }

    public OperatorHome getOperatorHome() throws ApplicationException {
        if (this.operatorHome == null) {
            this.operatorHome = this.getHome("java:global/ebf/ebf-ejb/OperatorHomeBean", OperatorHome.class);
        }
        return this.operatorHome;
    }
}

