/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.commandprocessor;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.marketsim.ApiResponseMessage;
import ar.com.sdd.marketsim.CommandRequest;
import ar.com.sdd.marketsim.InitalizerSmall;
import ar.com.sdd.marketsim.Marketsim;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
public class CommandProcessorApiEndpoint {
    final List<String> widgetCommands = List.of("help");

    @POST
    @ServerFileLogged
    @Path(value="/processCommand")
    @Produces(value={"application/json; charset=utf-8"})
    @Consumes(value={"application/json; charset=utf-8"})
    public Response processCommand(CommandRequest commandRequest) {
        ApiResponseMessage apiResponseMessage;
        InitalizerSmall initializer = new InitalizerSmall();
        Marketsim ms = new Marketsim();
        String[] commandParts = StringUtil.split((String)commandRequest.getCommandToProcess(), (char)' ', (int)1);
        String commandName = StringUtil.nonNull((String)commandParts[0]);
        if (StringUtil.isEmpty((String)commandName)) {
            apiResponseMessage = new ApiResponseMessage(1, "Command empty", false);
        } else if (commandName.equals("login")) {
            String userId;
            String string = userId = commandParts.length > 1 ? commandParts[1] : null;
            if (StringUtil.isEmpty((String)userId)) {
                apiResponseMessage = new ApiResponseMessage(4, "User " + userId + " logged successfully", this.determineIfWidget(commandName));
            } else {
                ms.initInstance(userId);
                ms.sendCommand(userId, "set ITEMSXPAGE 4000000");
                ms.sendCommand(userId, "set PATH_DB data");
                ms.sendCommand(userId, "set PATH_SC scripts");
                ms.sendCommand(userId, "set PATH_LG log");
                ms.sendCommand(userId, "set prompt 6");
                apiResponseMessage = new ApiResponseMessage(4, "User " + userId + " logged successfully", this.determineIfWidget(commandName));
            }
        } else {
            String sendCommandResult;
            try {
                sendCommandResult = ms.sendCommand(commandRequest.getUserName(), commandRequest.getCommandToProcess());
            }
            catch (Exception e) {
                return Response.serverError().entity((Object)new ApiResponseMessage(1, e.getMessage(), false)).build();
            }
            apiResponseMessage = sendCommandResult == null ? new ApiResponseMessage(2, "Invalid command: " + commandRequest.getCommandToProcess(), this.determineIfWidget(commandRequest.getCommandToProcess())) : new ApiResponseMessage(4, sendCommandResult, this.determineIfWidget(commandRequest.getCommandToProcess()));
        }
        return Response.ok().entity((Object)apiResponseMessage).build();
    }

    private boolean determineIfWidget(String commandName) {
        return commandName != null && this.widgetCommands.contains(commandName);
    }
}

