/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.session.login;

import ar.com.sdd.commons.util.PasswordUtil;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.marketsim.HomeManager;
import ar.com.sdd.marketsim.bo.operator.Operator;
import ar.com.sdd.marketsim.bo.operator.OperatorHome;
import ar.com.sdd.marketsim.session.APPSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class APPLoginModel {
    private static final Logger log = LogManager.getLogger(APPLoginModel.class);
    private PageContext pageContext;
    private String userName;
    private String userDescription;
    private String password;
    private String remoteAddress;

    public APPLoginModel(PageContext pageContext, String userName, String userDescription, String password) {
        this.pageContext = pageContext;
        this.userName = userName;
        this.userDescription = userDescription;
        this.password = password;
    }

    public APPSession login() {
        if (StringUtil.isEmpty((String)this.userName)) {
            throw new IllegalArgumentException("Username is empty");
        }
        if (StringUtil.isEmpty((String)this.remoteAddress)) {
            this.remoteAddress = ((HttpServletRequest)this.pageContext.getRequest()).getHeader("x-forwarded-for");
        }
        this.userName = this.userName.trim();
        this.userDescription = this.userDescription != null ? this.userDescription.trim() : this.userName;
        OperatorHome homeOperator = HomeManager.getInstance().getOperatorHome();
        Operator op = homeOperator.findByName(this.userName);
        if (op == null) {
            throw new IllegalArgumentException("user.name");
        }
        this.validateLogin(op);
        APPSession appSession = new APPSession(op, (HttpServletRequest)this.pageContext.getRequest());
        appSession.setRemoteAddress(this.remoteAddress);
        return appSession;
    }

    private void validateLogin(Operator op) throws IllegalArgumentException {
        String opInfo = "id:" + op.getId() + " Operador: " + this.userName;
        log.info("Validando acceso a: " + opInfo);
        this.password = this.password.trim();
        String encryptedPassword = PasswordUtil.getInstance().hashPassword(this.password + this.userName);
        boolean validated = op.validatePassword(encryptedPassword);
        if (!validated) {
            log.info("Acceso no validado, password incorrecta. {}", (Object)opInfo);
            throw new IllegalArgumentException("operator.login.invalid.password");
        }
    }
}

