package ar.com.sdd.mboapi.core;

import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.mboapi.model.PaymentStatusNotification;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import org.apache.log4j.Logger;
import org.jose4j.jwe.ContentEncryptionAlgorithmIdentifiers;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwe.KeyManagementAlgorithmIdentifiers;
import org.jose4j.jws.AlgorithmIdentifiers;
import org.jose4j.jws.JsonWebSignature;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;

public class MboApiConnector implements RestSecurityManager {

    private final static Logger log = Logger.getLogger(MboApiConnector.class);

    private final String username;
    private final String password;

    public MboApiConnector(MboApiConnectorContext context) {
        this.username = context.getSyndApiUsername();
        this.password = context.getSyndApiPassword();

        log.debug("Creando MboApiConnector para url [" + context.getSyndApiBaseUrl() + "], username [" + username + "], password [" + password + "]");

        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getSyndApiBaseUrl());
        //restConnector = new RestConnector(environment, this);
    }

    public void getToken()  throws RestConnectorException {
        String path="https://tts.sit.apib2b.citi.com/citiconnect/uat1/openbankingservices/v1/oauth/token";
        log.debug("[procesarCobranza] Request POST procesar cobranza, request [" + "request" + "] path [" + path + "]");
    }
    public void procesarCobranza(PaymentStatusNotification request) throws RestConnectorException {
        String path = "/BufferPayment";
        log.debug("[procesarCobranza] Request POST procesar cobranza, request [" + request + "] path [" + path + "]");
        //restConnector.genericPost(request, Void.class, path);
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", RestConnectorUtil.getBasicAuthHeader(username, password));
        }
        return builder;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public static void main(String[] args) {

        try {
/*
        2 SSL Certificadds
            SDD                   qa.sdd.sdd.com.ar
            Citi                  OK
        4 Encryption certificates
            SDD Sign            => qa.sdd.sdd.com.ar
                CITI Encryp        citigroupsoauat.xenc.citigroup.com

                SDD Descrypt    => qa.sdd.sdd.com.ar
            CITI sign              citigroupsoauat.dsig.citigroup.com  [FAIL]
*/


            //b.1)	Load Keystore file that has all certs
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream("d:/ax/certificados/mbo/ccapi/test.jks");
            String keyStorePwd = "";
            ks.load(fis, keyStorePwd.toCharArray());
            fis.close();

            //c)	Getting Private/Public Client Signing Key
            String clientSignKeyAlias = "sdd.sdd.com.ar";
            PrivateKey privateSignKey = (PrivateKey) ks.getKey(clientSignKeyAlias, "".toCharArray());
            X509Certificate signCert = (X509Certificate) ks.getCertificate("sdd.sdd.com.ar");
            signCert.checkValidity();

            //d)	Signing the Payload
            String oAuthPayload = "{\n" +
                    "  \"oAuthToken\":{\n" +
                    "    \"grantType\": \"client_credentials\",\n" +
                    "    \"scope\": \"/openbanking/v1\"\n" +
                    "  }\n" +
                    "}\n";

            JsonWebSignature jwsignature = new JsonWebSignature();
            jwsignature.setPayload(oAuthPayload);
            jwsignature.setAlgorithmHeaderValue(AlgorithmIdentifiers.RSA_USING_SHA256);
            jwsignature.setKey(privateSignKey);
            String oAuthPayloadSigned = jwsignature.getCompactSerialization();

            //e)	Getting Public Citi Encryption Key
            //String citiEncryptKeyAlias = "citigroupsoa.xenc.citigroup.com";
            String citiEncryptKeyAlias = "citigroupsoauat.xenc.citigroup.com";
            X509Certificate encryptCert = (X509Certificate) ks.getCertificate(citiEncryptKeyAlias);
            encryptCert.checkValidity();
            PublicKey publicEncryptKey = encryptCert.getPublicKey();

            //f)	Encrypt the Signed Payload
            JsonWebEncryption jwEncrypt = new JsonWebEncryption();
            jwEncrypt.setPlaintext(oAuthPayloadSigned);
            jwEncrypt.setAlgorithmHeaderValue(KeyManagementAlgorithmIdentifiers.RSA_OAEP_256);
            jwEncrypt.setEncryptionMethodHeaderParameter(ContentEncryptionAlgorithmIdentifiers.AES_128_CBC_HMAC_SHA_256);
            jwEncrypt.setKey(publicEncryptKey);
            String oAuthPayloadSignedEncrypted = jwEncrypt.getCompactSerialization();
            System.out.println("PAYLOAD");
            //System.out.println(oAuthPayload);
            System.out.println("PAYLOAD: SIG+ENC");
            //System.out.println(oAuthPayloadSignedEncrypted);

            //Auth API
            KeyStore clientStore = KeyStore.getInstance("JKS");
            String certPwd = "";
            //Authentication certificate: qa_sdd_sdd_com_ar
            clientStore.load(new FileInputStream("d:/ax/certificados/mbo/ccapi/test.jks"), certPwd.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(clientStore, certPwd.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            String proxyURL = "";
            Client client = new Client(new URLConnectionClientHandler(
                    new HttpURLConnectionFactory() {
                        Proxy proxy = null;

                        public HttpURLConnection getHttpURLConnection(URL url)
                                throws IOException {
                            if (proxy == null && !proxyURL.isEmpty()) {
                                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL, 8080));
                            } else {
                                proxy = Proxy.NO_PROXY;
                            }
                            return (HttpURLConnection) url.openConnection(proxy);
                        }
                    }), new DefaultClientConfig());

            String oAuthURL = "https://tts.sit.apib2b.citi.com/citiconnect/uat1/openbankingservices/v1/oauth/token";
            WebResource webResource = client.resource(oAuthURL);
            WebResource.Builder builder = webResource.type(MediaType.APPLICATION_JSON_TYPE);
            String clientID = "3bc5a546-f76d-45c9-a944-8cc0b10d43b1";
            String clientSecret = "fV7gW7nB0pS7vD1lP7gV5fS5mD4aX6sJ6bX7xG6sB5cS5fF4nSxx";
            builder.header(HttpHeaders.AUTHORIZATION, "Basic " + Base64.getEncoder().encodeToString(((clientID + ":" + clientSecret).getBytes())).replaceAll("(\\r|\\n)", ""));
            ClientResponse clientResponse = builder.post(ClientResponse.class, oAuthPayloadSignedEncrypted);
            System.out.println("RESPONSE HEADERS");
            System.out.println(clientResponse.getHeaders().get("apim-guid"));
            String responsePayload = clientResponse.getEntity(String.class);

            System.out.println("PLAIN");
            System.out.println(responsePayload);
            //NO://System.out.println("DECODED");
            //NO://System.out.println(Base64.getMimeDecoder().decode(responsePayload));

            //DECRIPT
            String clientDecryptKeyAlias = "sdd.sdd.com.ar";
            PrivateKey privateDecryptKey = (PrivateKey) ks.getKey(clientDecryptKeyAlias, keyStorePwd.toCharArray());
            //X509Certificate decryptCert = (X509Certificate)ks.getCertificate(clientDecryptKeyAlias);
            X509Certificate decryptCert = (X509Certificate) ks.getCertificate(citiEncryptKeyAlias);
            decryptCert.checkValidity();

            // d)	Decrypt the encrypted & signed Response Payload
            JsonWebEncryption jwEncryption = new JsonWebEncryption();
            jwEncryption.setKey(privateDecryptKey);
            jwEncryption.setCompactSerialization(responsePayload);
            String decryptedResponse = jwEncryption.getPlaintextString();
            System.out.println("DECRIPTED RESPONSE");
            System.out.println(decryptedResponse);


            //e)	Getting Public Citi Verification Key
            //String citiVerifyKeyAlias="citigroupsoa.dsig.citigroup.com";
            String citiVerifyKeyAlias = "citigroupsoauat.dsig.citigroup.com";
            X509Certificate signVerifyCert = (X509Certificate) ks.getCertificate(citiVerifyKeyAlias);
            signVerifyCert.checkValidity();
            PublicKey signVerifyKey = signVerifyCert.getPublicKey();

            //f)	Verifying the Signature of decrypted Response
            JsonWebSignature jwSignature = new JsonWebSignature();
            jwSignature.setKey(signVerifyKey);
            jwSignature.setCompactSerialization(decryptedResponse);
            //System.setProperty("org.jose4j.jws.getPayload-skip-verify","true");
            String verifiedResponse = jwSignature.getPayload();
            System.out.println("VERIFIED RESPONSE");
            System.out.println(verifiedResponse);


    /*
        String jsonURL="https://tts.sit.apib2b.citi.com/citiconnect/uat1/openbankingservices/v1/oauth/token";
        String oAuthToken = "fV7gW7nB0pS7vD1lP7gV5fS5mD4aX6sJ6bX7xG6sB5cS5fF4nSxx";
        WebResource webResource = client.resource(jsonURL).queryParam("client_id", clientID);
        WebResource.Builder builder = webResource.type(MediaType.APPLICATION_JSON);
        builder.header(HttpHeaders.AUTHORIZATION,"Bearer " + oAuthToken);
        ClientResponse clientResponse = builder.post(ClientResponse.class, payloadSignedEncrypted);
        String response = clientResponse.getEntity(String.class);
        //System.out.println(response);
        System.out.println(Base64.getMimeDecoder().decode(response));

     */
        } catch (Exception e) {

        }
    }
}