/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.core;

import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.mboapi.core.MboApiConnectorContext;
import ar.com.sdd.mboapi.model.PaymentStatusNotification;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jws.JsonWebSignature;

public class MboApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(MboApiConnector.class);
    private final String username;
    private final String password;

    public MboApiConnector(MboApiConnectorContext context) {
        this.username = context.getSyndApiUsername();
        this.password = context.getSyndApiPassword();
        log.debug((Object)("Creando MboApiConnector para url [" + context.getSyndApiBaseUrl() + "], username [" + this.username + "], password [" + this.password + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getSyndApiBaseUrl());
    }

    public void getToken() throws RestConnectorException {
        String path = "https://tts.sit.apib2b.citi.com/citiconnect/uat1/openbankingservices/v1/oauth/token";
        log.debug((Object)("[procesarCobranza] Request POST procesar cobranza, request [request] path [" + path + "]"));
    }

    public void procesarCobranza(PaymentStatusNotification request) throws RestConnectorException {
        String path = "/BufferPayment";
        log.debug((Object)("[procesarCobranza] Request POST procesar cobranza, request [" + request + "] path [" + path + "]"));
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", (Object)RestConnectorUtil.getBasicAuthHeader((String)this.username, (String)this.password));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public static void main(String[] args) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream("d:/ax/certificados/mbo/ccapi/test.jks");
            String keyStorePwd = "";
            ks.load(fis, keyStorePwd.toCharArray());
            fis.close();
            String clientSignKeyAlias = "sdd.sdd.com.ar";
            PrivateKey privateSignKey = (PrivateKey)ks.getKey(clientSignKeyAlias, "".toCharArray());
            X509Certificate signCert = (X509Certificate)ks.getCertificate("sdd.sdd.com.ar");
            signCert.checkValidity();
            String oAuthPayload = "{\n  \"oAuthToken\":{\n    \"grantType\": \"client_credentials\",\n    \"scope\": \"/openbanking/v1\"\n  }\n}\n";
            JsonWebSignature jwsignature = new JsonWebSignature();
            jwsignature.setPayload(oAuthPayload);
            jwsignature.setAlgorithmHeaderValue("RS256");
            jwsignature.setKey((Key)privateSignKey);
            String oAuthPayloadSigned = jwsignature.getCompactSerialization();
            String citiEncryptKeyAlias = "citigroupsoauat.xenc.citigroup.com";
            X509Certificate encryptCert = (X509Certificate)ks.getCertificate(citiEncryptKeyAlias);
            encryptCert.checkValidity();
            PublicKey publicEncryptKey = encryptCert.getPublicKey();
            JsonWebEncryption jwEncrypt = new JsonWebEncryption();
            jwEncrypt.setPlaintext(oAuthPayloadSigned);
            jwEncrypt.setAlgorithmHeaderValue("RSA-OAEP-256");
            jwEncrypt.setEncryptionMethodHeaderParameter("A128CBC-HS256");
            jwEncrypt.setKey((Key)publicEncryptKey);
            String oAuthPayloadSignedEncrypted = jwEncrypt.getCompactSerialization();
            System.out.println("PAYLOAD");
            System.out.println("PAYLOAD: SIG+ENC");
            KeyStore clientStore = KeyStore.getInstance("JKS");
            String certPwd = "";
            clientStore.load(new FileInputStream("d:/ax/certificados/mbo/ccapi/test.jks"), certPwd.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(clientStore, certPwd.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            final String proxyURL = "";
            Client client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){
                Proxy proxy = null;

                public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                    this.proxy = this.proxy == null && !proxyURL.isEmpty() ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL, 8080)) : Proxy.NO_PROXY;
                    return (HttpURLConnection)url.openConnection(this.proxy);
                }
            }), (ClientConfig)new DefaultClientConfig());
            String oAuthURL = "https://tts.sit.apib2b.citi.com/citiconnect/uat1/openbankingservices/v1/oauth/token";
            WebResource webResource = client.resource(oAuthURL);
            WebResource.Builder builder = webResource.type(MediaType.APPLICATION_JSON_TYPE);
            String clientID = "3bc5a546-f76d-45c9-a944-8cc0b10d43b1";
            String clientSecret = "fV7gW7nB0pS7vD1lP7gV5fS5mD4aX6sJ6bX7xG6sB5cS5fF4nSxx";
            builder.header("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString((clientID + ":" + clientSecret).getBytes()).replaceAll("(\\r|\\n)", "")));
            ClientResponse clientResponse = (ClientResponse)builder.post(ClientResponse.class, (Object)oAuthPayloadSignedEncrypted);
            System.out.println("RESPONSE HEADERS");
            System.out.println(clientResponse.getHeaders().get((Object)"apim-guid"));
            String responsePayload = (String)clientResponse.getEntity(String.class);
            System.out.println("PLAIN");
            System.out.println(responsePayload);
            String clientDecryptKeyAlias = "sdd.sdd.com.ar";
            PrivateKey privateDecryptKey = (PrivateKey)ks.getKey(clientDecryptKeyAlias, keyStorePwd.toCharArray());
            X509Certificate decryptCert = (X509Certificate)ks.getCertificate(citiEncryptKeyAlias);
            decryptCert.checkValidity();
            JsonWebEncryption jwEncryption = new JsonWebEncryption();
            jwEncryption.setKey((Key)privateDecryptKey);
            jwEncryption.setCompactSerialization(responsePayload);
            String decryptedResponse = jwEncryption.getPlaintextString();
            System.out.println("DECRIPTED RESPONSE");
            System.out.println(decryptedResponse);
            String citiVerifyKeyAlias = "citigroupsoauat.dsig.citigroup.com";
            X509Certificate signVerifyCert = (X509Certificate)ks.getCertificate(citiVerifyKeyAlias);
            signVerifyCert.checkValidity();
            PublicKey signVerifyKey = signVerifyCert.getPublicKey();
            JsonWebSignature jwSignature = new JsonWebSignature();
            jwSignature.setKey((Key)signVerifyKey);
            jwSignature.setCompactSerialization(decryptedResponse);
            String verifiedResponse = jwSignature.getPayload();
            System.out.println("VERIFIED RESPONSE");
            System.out.println(verifiedResponse);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

