/*
 * MultiBalance API
 * MultiBalance Online API.
 *
 * OpenAPI spec version: 1.0.10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package ar.com.sdd.mboapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * Response to payment API allows vendor to create request credit payment to citi accounts from their external accounts
 */
@Schema(description = "Response to payment API allows vendor to create request credit payment to citi accounts from their external accounts")
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2022-04-28T00:25:00.650348100-03:00[America/Buenos_Aires]")public class PaymentStatusNotification {

  @JsonProperty("original_end_to_end_id")

  private String originalEndToEndId = null;

  @JsonProperty("issuing_party_identifier")

  private String issuingPartyIdentifier = null;

  @JsonProperty("transaction_status")

  private String transactionStatus = null;

  @JsonProperty("reason")

  private Reason reason = null;

  @JsonProperty("accepted_amount")

  private BigDecimal acceptedAmount = null;

  @JsonProperty("debtor_decision_date_time")

  private String debtorDecisionDateTime = null;

  @JsonProperty("acceptance_date_time")

  private String acceptanceDateTime = null;

  @JsonProperty("account_servicer_reference")

  private String accountServicerReference = null;

  @JsonProperty("clearing_system_reference")

  private String clearingSystemReference = null;

  @JsonProperty("debtor_organisation_id")

  private String debtorOrganisationId = null;

  @JsonProperty("debtor_proxy_id")

  private String debtorProxyId = null;

  @JsonProperty("creditor_organisation_id")

  private String creditorOrganisationId = null;

  @JsonProperty("creditor_proxy_id")

  private String creditorProxyId = null;
  public PaymentStatusNotification originalEndToEndId(String originalEndToEndId) {
    this.originalEndToEndId = originalEndToEndId;
    return this;
  }

  

  /**
  * Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain
  * @return originalEndToEndId
  **/
  @Schema(required = true, description = "Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain")
  public String getOriginalEndToEndId() {
    return originalEndToEndId;
  }
  public void setOriginalEndToEndId(String originalEndToEndId) {
    this.originalEndToEndId = originalEndToEndId;
  }
  public PaymentStatusNotification issuingPartyIdentifier(String issuingPartyIdentifier) {
    this.issuingPartyIdentifier = issuingPartyIdentifier;
    return this;
  }

  

  /**
  * Party that issues the status (Unique and unambiguous identification of a financial institution, as assigned under an internationally recognised or proprietary identification scheme). BIC - Format pattern [A-Z0-9]{4,4}[A-Z]{2,2}[A-Z0-9]{2,2}([A-Z0-9]{3,3}){0,1}
  * @return issuingPartyIdentifier
  **/
  @Schema(description = "Party that issues the status (Unique and unambiguous identification of a financial institution, as assigned under an internationally recognised or proprietary identification scheme). BIC - Format pattern [A-Z0-9]{4,4}[A-Z]{2,2}[A-Z0-9]{2,2}([A-Z0-9]{3,3}){0,1}")
  public String getIssuingPartyIdentifier() {
    return issuingPartyIdentifier;
  }
  public void setIssuingPartyIdentifier(String issuingPartyIdentifier) {
    this.issuingPartyIdentifier = issuingPartyIdentifier;
  }
  public PaymentStatusNotification transactionStatus(String transactionStatus) {
    this.transactionStatus = transactionStatus;
    return this;
  }

  

  /**
  * Specifies the status of a transaction, in a coded form
  * @return transactionStatus
  **/
  @Schema(required = true, description = "Specifies the status of a transaction, in a coded form")
  public String getTransactionStatus() {
    return transactionStatus;
  }
  public void setTransactionStatus(String transactionStatus) {
    this.transactionStatus = transactionStatus;
  }
  public PaymentStatusNotification reason(Reason reason) {
    this.reason = reason;
    return this;
  }

  

  /**
  * Get reason
  * @return reason
  **/
  @Schema(description = "")
  public Reason getReason() {
    return reason;
  }
  public void setReason(Reason reason) {
    this.reason = reason;
  }
  public PaymentStatusNotification acceptedAmount(BigDecimal acceptedAmount) {
    this.acceptedAmount = acceptedAmount;
    return this;
  }

  

  /**
  * Amount accepted to be paid. Format: minInclusive 0,totalDigits 18,fractionDigits 5
  * @return acceptedAmount
  **/
  @Schema(description = "Amount accepted to be paid. Format: minInclusive 0,totalDigits 18,fractionDigits 5")
  public BigDecimal getAcceptedAmount() {
    return acceptedAmount;
  }
  public void setAcceptedAmount(BigDecimal acceptedAmount) {
    this.acceptedAmount = acceptedAmount;
  }
  public PaymentStatusNotification debtorDecisionDateTime(String debtorDecisionDateTime) {
    this.debtorDecisionDateTime = debtorDecisionDateTime;
    return this;
  }

  

  /**
  * Date and time on when the debtor has accepted or rejected the request&lt;br/&gt; UTC offset format (YYYY-MM-DDThh:mm:ss.sss+/-hh:mm) &lt;br/&gt;Note on the time format: 1) beginning / end of calendar day 00:00:00 &#x3D; the beginning of a calendar day 24:00:00 &#x3D; the end of a calendar day 2) fractions of second in time format Decimal fractions of seconds may be included. In this case, the involved parties shall agree on the maximum number of digits that are allowed. It will conttains timestamp for order received by SDD
  * @return debtorDecisionDateTime
  **/
  @Schema(example = "2016-06-23T09:07:21.205-07:00", description = "Date and time on when the debtor has accepted or rejected the request<br/> UTC offset format (YYYY-MM-DDThh:mm:ss.sss+/-hh:mm) <br/>Note on the time format: 1) beginning / end of calendar day 00:00:00 = the beginning of a calendar day 24:00:00 = the end of a calendar day 2) fractions of second in time format Decimal fractions of seconds may be included. In this case, the involved parties shall agree on the maximum number of digits that are allowed. It will conttains timestamp for order received by SDD")
  public String getDebtorDecisionDateTime() {
    return debtorDecisionDateTime;
  }
  public void setDebtorDecisionDateTime(String debtorDecisionDateTime) {
    this.debtorDecisionDateTime = debtorDecisionDateTime;
  }
  public PaymentStatusNotification acceptanceDateTime(String acceptanceDateTime) {
    this.acceptanceDateTime = acceptanceDateTime;
    return this;
  }

  

  /**
  * Point in time when the payment order from the initiating party meets the processing conditions of the account servicing agent. This means that the account servicing agent has received the payment order and has applied checks such as authorisation, availability of funds&lt;br/&gt; UTC offset format (YYYY-MM-DDThh:mm:ss.sss+/-hh:mm) &lt;br/&gt;Note on the time format: 1) beginning / end of calendar day 00:00:00 &#x3D; the beginning of a calendar day 24:00:00 &#x3D; the end of a calendar day 2) fractions of second in time format Decimal fractions of seconds may be included. In this case, the involved parties shall agree on the maximum number of digits that are allowed.
  * @return acceptanceDateTime
  **/
  @Schema(example = "2016-06-23T09:07:21.205-07:00", description = "Point in time when the payment order from the initiating party meets the processing conditions of the account servicing agent. This means that the account servicing agent has received the payment order and has applied checks such as authorisation, availability of funds<br/> UTC offset format (YYYY-MM-DDThh:mm:ss.sss+/-hh:mm) <br/>Note on the time format: 1) beginning / end of calendar day 00:00:00 = the beginning of a calendar day 24:00:00 = the end of a calendar day 2) fractions of second in time format Decimal fractions of seconds may be included. In this case, the involved parties shall agree on the maximum number of digits that are allowed.")
  public String getAcceptanceDateTime() {
    return acceptanceDateTime;
  }
  public void setAcceptanceDateTime(String acceptanceDateTime) {
    this.acceptanceDateTime = acceptanceDateTime;
  }
  public PaymentStatusNotification accountServicerReference(String accountServicerReference) {
    this.accountServicerReference = accountServicerReference;
    return this;
  }

  

  /**
  * Unique reference, as assigned by the account servicing institution, to unambiguously identify the instruction. (Debin ID)
  * @return accountServicerReference
  **/
  @Schema(example = "76V4MR2ZPZZ4G8Y9DEZOL1", description = "Unique reference, as assigned by the account servicing institution, to unambiguously identify the instruction. (Debin ID)")
  public String getAccountServicerReference() {
    return accountServicerReference;
  }
  public void setAccountServicerReference(String accountServicerReference) {
    this.accountServicerReference = accountServicerReference;
  }
  public PaymentStatusNotification clearingSystemReference(String clearingSystemReference) {
    this.clearingSystemReference = clearingSystemReference;
    return this;
  }

  

  /**
  * Unique reference, as assigned by a clearing system, to unambiguously identify the instruction. (SDD ID)
  * @return clearingSystemReference
  **/
  @Schema(description = "Unique reference, as assigned by a clearing system, to unambiguously identify the instruction. (SDD ID)")
  public String getClearingSystemReference() {
    return clearingSystemReference;
  }
  public void setClearingSystemReference(String clearingSystemReference) {
    this.clearingSystemReference = clearingSystemReference;
  }
  public PaymentStatusNotification debtorOrganisationId(String debtorOrganisationId) {
    this.debtorOrganisationId = debtorOrganisationId;
    return this;
  }

  

  /**
  * Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for debtor.
  * @return debtorOrganisationId
  **/
  @Schema(example = "30-71234567-0", description = "Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for debtor.")
  public String getDebtorOrganisationId() {
    return debtorOrganisationId;
  }
  public void setDebtorOrganisationId(String debtorOrganisationId) {
    this.debtorOrganisationId = debtorOrganisationId;
  }
  public PaymentStatusNotification debtorProxyId(String debtorProxyId) {
    this.debtorProxyId = debtorProxyId;
    return this;
  }

  

  /**
  * CBU for debit 3RD PARTY account
  * @return debtorProxyId
  **/
  @Schema(example = "0078888100008247960170", description = "CBU for debit 3RD PARTY account")
  public String getDebtorProxyId() {
    return debtorProxyId;
  }
  public void setDebtorProxyId(String debtorProxyId) {
    this.debtorProxyId = debtorProxyId;
  }
  public PaymentStatusNotification creditorOrganisationId(String creditorOrganisationId) {
    this.creditorOrganisationId = creditorOrganisationId;
    return this;
  }

  

  /**
  * Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for creditor.
  * @return creditorOrganisationId
  **/
  @Schema(example = "30-71234567-0", description = "Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for creditor.")
  public String getCreditorOrganisationId() {
    return creditorOrganisationId;
  }
  public void setCreditorOrganisationId(String creditorOrganisationId) {
    this.creditorOrganisationId = creditorOrganisationId;
  }
  public PaymentStatusNotification creditorProxyId(String creditorProxyId) {
    this.creditorProxyId = creditorProxyId;
    return this;
  }

  

  /**
  * CBU for credit account.
  * @return creditorProxyId
  **/
  @Schema(example = "0168888100008247960170", description = "CBU for credit account.")
  public String getCreditorProxyId() {
    return creditorProxyId;
  }
  public void setCreditorProxyId(String creditorProxyId) {
    this.creditorProxyId = creditorProxyId;
  }
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentStatusNotification paymentStatusNotification = (PaymentStatusNotification) o;
    return Objects.equals(this.originalEndToEndId, paymentStatusNotification.originalEndToEndId) &&
        Objects.equals(this.issuingPartyIdentifier, paymentStatusNotification.issuingPartyIdentifier) &&
        Objects.equals(this.transactionStatus, paymentStatusNotification.transactionStatus) &&
        Objects.equals(this.reason, paymentStatusNotification.reason) &&
        Objects.equals(this.acceptedAmount, paymentStatusNotification.acceptedAmount) &&
        Objects.equals(this.debtorDecisionDateTime, paymentStatusNotification.debtorDecisionDateTime) &&
        Objects.equals(this.acceptanceDateTime, paymentStatusNotification.acceptanceDateTime) &&
        Objects.equals(this.accountServicerReference, paymentStatusNotification.accountServicerReference) &&
        Objects.equals(this.clearingSystemReference, paymentStatusNotification.clearingSystemReference) &&
        Objects.equals(this.debtorOrganisationId, paymentStatusNotification.debtorOrganisationId) &&
        Objects.equals(this.debtorProxyId, paymentStatusNotification.debtorProxyId) &&
        Objects.equals(this.creditorOrganisationId, paymentStatusNotification.creditorOrganisationId) &&
        Objects.equals(this.creditorProxyId, paymentStatusNotification.creditorProxyId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(originalEndToEndId, issuingPartyIdentifier, transactionStatus, reason, acceptedAmount, debtorDecisionDateTime, acceptanceDateTime, accountServicerReference, clearingSystemReference, debtorOrganisationId, debtorProxyId, creditorOrganisationId, creditorProxyId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentStatusNotification {\n");
    
    sb.append("    originalEndToEndId: ").append(toIndentedString(originalEndToEndId)).append("\n");
    sb.append("    issuingPartyIdentifier: ").append(toIndentedString(issuingPartyIdentifier)).append("\n");
    sb.append("    transactionStatus: ").append(toIndentedString(transactionStatus)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    acceptedAmount: ").append(toIndentedString(acceptedAmount)).append("\n");
    sb.append("    debtorDecisionDateTime: ").append(toIndentedString(debtorDecisionDateTime)).append("\n");
    sb.append("    acceptanceDateTime: ").append(toIndentedString(acceptanceDateTime)).append("\n");
    sb.append("    accountServicerReference: ").append(toIndentedString(accountServicerReference)).append("\n");
    sb.append("    clearingSystemReference: ").append(toIndentedString(clearingSystemReference)).append("\n");
    sb.append("    debtorOrganisationId: ").append(toIndentedString(debtorOrganisationId)).append("\n");
    sb.append("    debtorProxyId: ").append(toIndentedString(debtorProxyId)).append("\n");
    sb.append("    creditorOrganisationId: ").append(toIndentedString(creditorOrganisationId)).append("\n");
    sb.append("    creditorProxyId: ").append(toIndentedString(creditorProxyId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
