/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.SSLSocketFactoryGenerator;
import ar.com.sdd.mboapi.core.MboApiConnectorContext;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.jose4j.json.internal.json_simple.parser.JSONParser;
import org.jose4j.json.internal.json_simple.parser.ParseException;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class MboApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(MboApiConnector.class);
    private MboApiConnectorContext mboApiConnectorContext;
    private PrivateKey privateSignKey;
    private PublicKey publicEncryptKey;
    private PrivateKey privateDecryptKey;
    private PublicKey signVerifyKey;
    private boolean debugMode = false;
    private final int HttpStatus_SC_OK = 200;
    private final int TokenExpirationSafeMarginSecs = 15;
    String token;
    Date tokenExpiration;

    public MboApiConnector(MboApiConnectorContext context) throws GeneralSecurityException, IOException {
        this.mboApiConnectorContext = context;
        this.setDebugMode(context.getDebugMode());
        if (this.debugMode) {
            log.debug((Object)("BaseURL:" + context.getBaseURL()));
            log.debug((Object)("Keystore:" + context.getKeystorePath()));
            log.debug((Object)("ClientId:" + context.getClientId()));
            log.debug((Object)("ClientAuth:" + context.getClientAuthAlias()));
            log.debug((Object)("ServerAuth:" + context.getServerAuthAlias()));
            log.debug((Object)("ClientCryp:" + context.getClientCrypAlias()));
            log.debug((Object)("ServerCryp:" + context.getServerCrypAlias()));
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(this.mboApiConnectorContext.getKeystorePath());
        ks.load(fis, this.mboApiConnectorContext.getKeystorePass().toCharArray());
        fis.close();
        this.privateSignKey = (PrivateKey)ks.getKey(this.mboApiConnectorContext.getClientCrypAlias(), this.mboApiConnectorContext.getKeystorePass().toCharArray());
        if (this.debugMode) {
            X509Certificate signCert = (X509Certificate)ks.getCertificate(this.mboApiConnectorContext.getClientCrypAlias());
            try {
                signCert.checkValidity();
                log.debug((Object)"MBOAPI.CERT:CLIENT AUTH VALIDITY: OK");
            }
            catch (Exception e) {
                log.debug((Object)("MBOAPI.CERT:CLIENT AUTH VALIDITY: ERROR:" + e));
            }
        }
        X509Certificate encryptCert = (X509Certificate)ks.getCertificate(this.mboApiConnectorContext.getServerCrypAlias());
        if (this.debugMode) {
            try {
                encryptCert.checkValidity();
                log.debug((Object)"MBOAPI.CERT:SERVER CRYPT VALIDITY: OK");
            }
            catch (Exception e) {
                log.debug((Object)("MBOAPI.CERT:SERVER CRYPT VALIDITY: ERROR:" + e));
            }
        }
        this.publicEncryptKey = encryptCert.getPublicKey();
        this.privateDecryptKey = (PrivateKey)ks.getKey(this.mboApiConnectorContext.getClientCrypAlias(), this.mboApiConnectorContext.getKeystorePass().toCharArray());
        if (this.debugMode) {
            try {
                X509Certificate decryptCert = (X509Certificate)ks.getCertificate(this.mboApiConnectorContext.getClientCrypAlias());
                decryptCert.checkValidity();
                log.debug((Object)"MBOAPI.CERT:CLIENT CRYPT VALIDITY: OK");
            }
            catch (Exception e) {
                log.debug((Object)("MBOAPI.CERT:CLIENT CRYPT VALIDITY: ERROR:" + e));
            }
        }
        X509Certificate signVerifyCert = (X509Certificate)ks.getCertificate(this.mboApiConnectorContext.getServerAuthAlias());
        if (this.debugMode) {
            try {
                signVerifyCert.checkValidity();
                log.debug((Object)"MBOAPI.CERT:SERVER SIGN VALIDITY: OK");
            }
            catch (Exception e) {
                log.debug((Object)("MBOAPI.CERT:SERVER SIGN VALIDITY: ERROR:" + e));
            }
        }
        this.signVerifyKey = signVerifyCert.getPublicKey();
        SSLSocketFactory socketFactory = new SSLSocketFactoryGenerator(this.mboApiConnectorContext.getClientAuthAlias(), this.mboApiConnectorContext.getKeystorePath(), this.mboApiConnectorContext.getKeystorePass()).getSSLSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
        this.tokenExpiration = new Date(101, 0, 1);
    }

    public String encrypt(String payload) throws JoseException {
        if (this.debugMode) {
            log.debug((Object)("MBOAPI.PAYLOAD PLAIN:" + payload));
        }
        JsonWebSignature jwsignature = new JsonWebSignature();
        jwsignature.setPayload(payload);
        jwsignature.setAlgorithmHeaderValue("RS256");
        jwsignature.setKey((Key)this.privateSignKey);
        String oAuthPayloadSigned = jwsignature.getCompactSerialization();
        JsonWebEncryption jwEncrypt = new JsonWebEncryption();
        jwEncrypt.setPlaintext(oAuthPayloadSigned);
        jwEncrypt.setAlgorithmHeaderValue("RSA-OAEP-256");
        jwEncrypt.setEncryptionMethodHeaderParameter("A128CBC-HS256");
        jwEncrypt.setKey((Key)this.publicEncryptKey);
        String payloadSignedEncrypted = jwEncrypt.getCompactSerialization();
        if (this.debugMode) {
            log.debug((Object)("MBOAPI.PAYLOAD SIGN+CRYPT:" + payloadSignedEncrypted));
        }
        return payloadSignedEncrypted;
    }

    public String decrypt(String responsePayload) throws JoseException {
        JsonWebEncryption jwEncryption = new JsonWebEncryption();
        if (this.debugMode) {
            log.debug((Object)("MBOAPI.PAYLOAD ENCRYPTED KEY:" + this.privateDecryptKey));
            log.debug((Object)("MBOAPI.PAYLOAD ENCRYPTED RESPONSE:" + responsePayload));
        }
        jwEncryption.setKey((Key)this.privateDecryptKey);
        jwEncryption.setCompactSerialization(responsePayload);
        jwEncryption.setAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"RSA1_5", "RSA-OAEP-256"}));
        String decryptedResponse = jwEncryption.getPlaintextString();
        if (this.debugMode) {
            log.debug((Object)("MBOAPI.PAYLOAD DECRYPTED RESPONSE:" + decryptedResponse));
        }
        JsonWebSignature jwSignature = new JsonWebSignature();
        jwSignature.setKey((Key)this.signVerifyKey);
        jwSignature.setCompactSerialization(decryptedResponse);
        if (this.debugMode) {
            System.setProperty("org.jose4j.jws.getPayload-skip-verify", "true");
        }
        String verifiedResponse = jwSignature.getPayload();
        if (this.debugMode) {
            log.debug((Object)("MBOAPI.PAYLOAD VERIFIED RESPONSE:" + verifiedResponse));
        }
        return verifiedResponse;
    }

    private Client createClient() throws GeneralSecurityException, IOException {
        SSLSocketFactory socketFactory = new SSLSocketFactoryGenerator(this.mboApiConnectorContext.getClientAuthAlias(), this.mboApiConnectorContext.getKeystorePath(), this.mboApiConnectorContext.getKeystorePass()).getSSLSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
        final String proxyURL = "";
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){
            Proxy proxy = null;

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                this.proxy = this.proxy == null && !proxyURL.isEmpty() ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL, 8080)) : Proxy.NO_PROXY;
                return (HttpURLConnection)url.openConnection(this.proxy);
            }
        }), (ClientConfig)new DefaultClientConfig());
        return client;
    }

    private String postOauthPayload(String apiURL, String payload) throws JoseException, GeneralSecurityException, IOException {
        String payloadSignedEncrypted = this.encrypt(payload);
        Client client = this.createClient();
        String clientID = this.mboApiConnectorContext.getClientId();
        String clientSecret = this.mboApiConnectorContext.getClientSecret();
        WebResource webResource = client.resource(apiURL);
        WebResource.Builder builder = (WebResource.Builder)webResource.type(MediaType.APPLICATION_JSON_TYPE).accept(new String[]{"application/json"});
        String authHeader = "Basic " + Base64.getEncoder().encodeToString((clientID + ":" + clientSecret).getBytes()).replaceAll("[\\r|\\n]", "");
        builder.header("Authorization", (Object)authHeader);
        ClientResponse clientResponse = (ClientResponse)builder.post(ClientResponse.class, (Object)payloadSignedEncrypted);
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        RestConnector restConnector = new RestConnector(environment, (RestSecurityManager)this);
        if (this.debugMode) {
            log.debug((Object)("MBO.REQUEST HEADER:Authorization " + authHeader));
        }
        if (clientResponse.getStatus() != 200) {
            log.error((Object)("MBO.REQUEST RESPONSE HEADER:" + clientResponse.getHeaders()));
        }
        log.debug((Object)("MBO.REQUEST APIM-GUID:" + clientResponse.getHeaders().get((Object)"apim-guid")));
        String responsePayload = (String)clientResponse.getEntity(String.class);
        String resultPayload = this.decrypt(responsePayload);
        if (this.debugMode) {
            log.debug((Object)("MBO.PAYLOAD RESULT:" + resultPayload));
        }
        return resultPayload;
    }

    private String postPayload(String apiURL, String payload) throws JoseException, GeneralSecurityException, IOException {
        ClientResponse clientResponse;
        String payloadSignedEncrypted = this.encrypt(payload);
        Client client = this.createClient();
        String clientID = this.mboApiConnectorContext.getClientId();
        WebResource webResource = client.resource(apiURL).queryParam("client_id", clientID);
        WebResource.Builder builder = (WebResource.Builder)webResource.type(MediaType.APPLICATION_JSON_TYPE).accept(new String[]{"application/json"});
        String authHeader = "Bearer " + this.getToken(false);
        builder.header("Authorization", (Object)authHeader);
        if (this.debugMode) {
            log.debug((Object)("MBO.REQUEST HEADER:Authorization " + authHeader));
        }
        if ((clientResponse = (ClientResponse)builder.post(ClientResponse.class, (Object)payloadSignedEncrypted)).getStatus() != 200) {
            log.error((Object)("MBO.REQUEST RESPONSE HEADER:" + clientResponse.getHeaders()));
        }
        log.debug((Object)("MBO.REQUEST APIM-GUID:" + clientResponse.getHeaders().get((Object)"apim-guid")));
        String responsePayload = (String)clientResponse.getEntity(String.class);
        String resultPayload = this.decrypt(responsePayload);
        if (this.debugMode) {
            log.debug((Object)("MBO.PAYLOAD RESULT:" + resultPayload));
        }
        return resultPayload;
    }

    public String getToken(boolean force) throws JoseException, GeneralSecurityException, IOException {
        String apiPath = "/openbankingservices/v1/oauth/token";
        JSONObject oAuthToken = new JSONObject();
        oAuthToken.put((Object)"grantType", (Object)"client_credentials");
        oAuthToken.put((Object)"scope", (Object)"/openbanking/v1");
        JSONObject payload = new JSONObject();
        payload.put((Object)"oAuthToken", (Object)oAuthToken);
        if (!force && new Date().before(this.tokenExpiration)) {
            return this.token;
        }
        String result = this.postOauthPayload(MboApiConnector.normalizeURL(this.mboApiConnectorContext.getBaseURL(), "/openbankingservices/v1/oauth/token"), payload.toJSONString());
        try {
            JSONParser jsonParser = new JSONParser();
            JSONObject oToken = (JSONObject)jsonParser.parse(result);
            Map oTokenToken = (Map)oToken.get((Object)"token");
            this.token = (String)oTokenToken.get("access_token");
            this.tokenExpiration = DateUtils.addSeconds((Date)new Date(), (int)(Integer.parseInt((String)oTokenToken.get("expires_in")) - 15));
        }
        catch (Exception e) {
            log.error((Object)("Obteniendo el token: " + e));
            log.debug((Object)("PAYLOAD:" + result));
        }
        return this.token;
    }

    public JSONObject postStatusReport(String payload) throws JoseException, ParseException, GeneralSecurityException, IOException {
        String apiPath = "/openbanking/v1/requesttopay/status";
        String result = this.postPayload(MboApiConnector.normalizeURL(this.mboApiConnectorContext.getBaseURL(), "/openbanking/v1/requesttopay/status"), payload);
        JSONParser jsonParser = new JSONParser();
        return (JSONObject)jsonParser.parse(result);
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public static String normalizeURL(String baseUrl, String apiUrl) {
        try {
            URI uri = new URI(baseUrl + "/" + apiUrl);
            return uri.normalize().toString();
        }
        catch (Exception e) {
            log.error((Object)e);
            return baseUrl + apiUrl;
        }
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        return builder;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

