/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.api.auth;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;
import ar.com.sdd.commons.rest.model.OAuth2SsoCredential;
import ar.com.sdd.mboapi.api.auth.AuthEbfApiService;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/mboapi/v1_0/auth")
public class AuthEbfApiEndpoint {
    @Inject
    private AuthEbfApiService authEbfApiService;

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/token.oauth2")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response postTokenOauth2(@PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        return this.authEbfApiService.postTokenOauth2(applicationId, AuthEbfApiService.OWNER_LOGIN_TYPE.BY_NAME, ownerId, oauthCredentials, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/ssocheck/{tokenId}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getSsoCheck(@PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="tokenId") String tokenId, @Context SecurityContext securityContext) {
        return this.authEbfApiService.getSsoCheck(applicationId, ownerId, tokenId, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/session")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getSession(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @Context SecurityContext securityContext) {
        return this.authEbfApiService.getSession(authorization, applicationId, ownerId, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/ssolink")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response postSsoLink(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, OAuth2SsoCredential oauthCredentials, @Context SecurityContext securityContext) {
        return this.authEbfApiService.postSsoLink(authorization, applicationId, ownerId, oauthCredentials, securityContext);
    }
}

