/*
 * MultiBalance API
 * MultiBalance Online API.
 *
 * OpenAPI spec version: 1.0.9
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package ar.com.sdd.mboapi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Error response + end_to_end_id
 */
@Schema(description = "Error response + end_to_end_id")
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2022-04-12T11:54:01.467961400-03:00[America/Buenos_Aires]")public class RequestToPayResponse {

  @SerializedName("tracking_code")
  private String trackingCode = null;

  @SerializedName("ref_id")
  private Object refId = null;
  /**
   * Overall status
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    SUCCESS("SUCCESS"),
    FAILURE("FAILURE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return StatusEnum.fromValue(String.valueOf(value));
      }
    }
  }
  @SerializedName("status")
  private StatusEnum status = null;

  @SerializedName("http_code")
  private Integer httpCode = null;

  @SerializedName("errors")
  private List<ErrorResponseErrors> errors = null;

  @SerializedName("end_to_end_id")
  private String endToEndId = null;
  public RequestToPayResponse trackingCode(String trackingCode) {
    this.trackingCode = trackingCode;
    return this;
  }

  

  /**
  * Unique Error tracking unique number (not an error Code)
  * @return trackingCode
  **/
  @Schema(description = "Unique Error tracking unique number (not an error Code)")
  public String getTrackingCode() {
    return trackingCode;
  }
  public void setTrackingCode(String trackingCode) {
    this.trackingCode = trackingCode;
  }
  public RequestToPayResponse refId(Object refId) {
    this.refId = refId;
    return this;
  }

  

  /**
  * id assigned for every request initiated by client at api gateway layer [apim] which can be used for tracing purposes
  * @return refId
  **/
  @Schema(description = "id assigned for every request initiated by client at api gateway layer [apim] which can be used for tracing purposes")
  public Object getRefId() {
    return refId;
  }
  public void setRefId(Object refId) {
    this.refId = refId;
  }
  public RequestToPayResponse status(StatusEnum status) {
    this.status = status;
    return this;
  }

  

  /**
  * Overall status
  * @return status
  **/
  @Schema(description = "Overall status")
  public StatusEnum getStatus() {
    return status;
  }
  public void setStatus(StatusEnum status) {
    this.status = status;
  }
  public RequestToPayResponse httpCode(Integer httpCode) {
    this.httpCode = httpCode;
    return this;
  }

  

  /**
  * HTTP Error code: 200 for OK, 4xx 5xx for errors
  * @return httpCode
  **/
  @Schema(description = "HTTP Error code: 200 for OK, 4xx 5xx for errors")
  public Integer getHttpCode() {
    return httpCode;
  }
  public void setHttpCode(Integer httpCode) {
    this.httpCode = httpCode;
  }
  public RequestToPayResponse errors(List<ErrorResponseErrors> errors) {
    this.errors = errors;
    return this;
  }

  public RequestToPayResponse addErrorsItem(ErrorResponseErrors errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<ErrorResponseErrors>();
    }
    this.errors.add(errorsItem);
    return this;
  }

  /**
  * one enty with error description
  * @return errors
  **/
  @Schema(description = "one enty with error description")
  public List<ErrorResponseErrors> getErrors() {
    return errors;
  }
  public void setErrors(List<ErrorResponseErrors> errors) {
    this.errors = errors;
  }
  public RequestToPayResponse endToEndId(String endToEndId) {
    this.endToEndId = endToEndId;
    return this;
  }

  

  /**
  * Unique identification assigned by the initiating party to unambiguously identify the transaction
  * @return endToEndId
  **/
  @Schema(description = "Unique identification assigned by the initiating party to unambiguously identify the transaction")
  public String getEndToEndId() {
    return endToEndId;
  }
  public void setEndToEndId(String endToEndId) {
    this.endToEndId = endToEndId;
  }
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RequestToPayResponse requestToPayResponse = (RequestToPayResponse) o;
    return Objects.equals(this.trackingCode, requestToPayResponse.trackingCode) &&
        Objects.equals(this.refId, requestToPayResponse.refId) &&
        Objects.equals(this.status, requestToPayResponse.status) &&
        Objects.equals(this.httpCode, requestToPayResponse.httpCode) &&
        Objects.equals(this.errors, requestToPayResponse.errors) &&
        Objects.equals(this.endToEndId, requestToPayResponse.endToEndId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(trackingCode, refId, status, httpCode, errors, endToEndId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RequestToPayResponse {\n");
    
    sb.append("    trackingCode: ").append(toIndentedString(trackingCode)).append("\n");
    sb.append("    refId: ").append(toIndentedString(refId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    httpCode: ").append(toIndentedString(httpCode)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    endToEndId: ").append(toIndentedString(endToEndId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
