package ar.com.sdd.mboapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.mboapi.model.RequestToPayInstruction;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/mboapi/v1_0/payment")
public class PaymentMboApiEndpoint {

    @Inject
    private PaymentMboApiService paymentMboApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/requestToPay")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postRequestToPay(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, RequestToPayInstruction requestToPayInstruction, @Context SecurityContext securityContext) {
        return paymentMboApiService.postRequestToPay(authorization, applicationId, ownerId, requestToPayInstruction, securityContext);
    }
}