/*
 * MultiBalance API
 * MultiBalance Online API.
 *
 * OpenAPI spec version: 1.0.9
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package ar.com.sdd.mboapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.Objects;

/**
 * A request to pay instruction, associated to a debin, with: concept&#x3D;Servicio MTBA; timeout&#x3D;9min; prestacion&#x3D;to be defined  
 */
@Schema(description = "A request to pay instruction, associated to a debin, with: concept=Servicio MTBA; timeout=9min; prestacion=to be defined  ")
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2022-04-12T17:58:53.176209900-03:00[America/Buenos_Aires]")public class RequestToPayInstruction {

  @JsonProperty("end_to_end_id")

  private String endToEndId = null;

  @JsonProperty("payment_method")

  private String paymentMethod = null;

  @JsonProperty("requested_execution_date_time")

  private String requestedExecutionDatetime = null;

  @JsonProperty("initiating_party")

  private InitiatingParty initiatingParty = null;

  @JsonProperty("debtor")

  private Debtor debtor = null;

  @JsonProperty("debtor_agent")

  private DebtorAgent debtorAgent = null;

  @JsonProperty("ultimate_debtor")

  private UltimateDebtor ultimateDebtor = null;

  @JsonProperty("instructed_amount")

  private Double instructedAmount = null;

  @JsonProperty("charge_bearer")

  private String chargeBearer = null;

  @JsonProperty("creditor_agent")

  private CreditorAgent creditorAgent = null;

  @JsonProperty("creditor")

  private Creditor creditor = null;

  @JsonProperty("ultimate_creditor")

  private UltimateCreditor ultimateCreditor = null;

  @JsonProperty("remittance_information")

  private String remittanceInformation = null;

  @JsonProperty("additional_information")

  private String additionalInformation = null;
  public RequestToPayInstruction endToEndId(String endToEndId) {
    this.endToEndId = endToEndId;
    return this;
  }

  

  /**
  * Unique identification assigned by the initiating party to unambiguously identify the transaction
  * @return endToEndId
  **/
  @Schema(required = true, description = "Unique identification assigned by the initiating party to unambiguously identify the transaction")
  public String getEndToEndId() {
    return endToEndId;
  }
  public void setEndToEndId(String endToEndId) {
    this.endToEndId = endToEndId;
  }
  public RequestToPayInstruction paymentMethod(String paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  

  /**
  * Specifies the means of payment that will be used to move the amount of money.Not used.Only can be TRF
  * @return paymentMethod
  **/
  @Schema(example = "TRF", description = "Specifies the means of payment that will be used to move the amount of money.Not used.Only can be TRF")
  public String getPaymentMethod() {
    return paymentMethod;
  }
  public void setPaymentMethod(String paymentMethod) {
    this.paymentMethod = paymentMethod;
  }
  public RequestToPayInstruction requestedExecutionDatetime(String requestedExecutionDatetime) {
    this.requestedExecutionDatetime = requestedExecutionDatetime;
    return this;
  }

  

  /**
  * Date at which the initiating party requests the clearing agent to process the payment. If payment by cheque, the date when the cheque must be generated by the bank. Not used.Should be empty or NOW
  * @return requestedExecutionDatetime
  **/
  @Schema(example = "2016-06-23T09:07:21.205-07:00", description = "Date at which the initiating party requests the clearing agent to process the payment. If payment by cheque, the date when the cheque must be generated by the bank. Not used.Should be empty or NOW")
  public String getRequestedExecutionDatetime() {
    return requestedExecutionDatetime;
  }
  public void setRequestedExecutionDatetime(String requestedExecutionDatetime) {
    this.requestedExecutionDatetime = requestedExecutionDatetime;
  }
  public RequestToPayInstruction initiatingParty(InitiatingParty initiatingParty) {
    this.initiatingParty = initiatingParty;
    return this;
  }

  

  /**
  * Get initiatingParty
  * @return initiatingParty
  **/
  @Schema(description = "")
  public InitiatingParty getInitiatingParty() {
    return initiatingParty;
  }
  public void setInitiatingParty(InitiatingParty initiatingParty) {
    this.initiatingParty = initiatingParty;
  }
  public RequestToPayInstruction debtor(Debtor debtor) {
    this.debtor = debtor;
    return this;
  }

  

  /**
  * Get debtor
  * @return debtor
  **/
  @Schema(required = true, description = "")
  public Debtor getDebtor() {
    return debtor;
  }
  public void setDebtor(Debtor debtor) {
    this.debtor = debtor;
  }
  public RequestToPayInstruction debtorAgent(DebtorAgent debtorAgent) {
    this.debtorAgent = debtorAgent;
    return this;
  }

  

  /**
  * Get debtorAgent
  * @return debtorAgent
  **/
  @Schema(description = "")
  public DebtorAgent getDebtorAgent() {
    return debtorAgent;
  }
  public void setDebtorAgent(DebtorAgent debtorAgent) {
    this.debtorAgent = debtorAgent;
  }
  public RequestToPayInstruction ultimateDebtor(UltimateDebtor ultimateDebtor) {
    this.ultimateDebtor = ultimateDebtor;
    return this;
  }

  

  /**
  * Get ultimateDebtor
  * @return ultimateDebtor
  **/
  @Schema(description = "")
  public UltimateDebtor getUltimateDebtor() {
    return ultimateDebtor;
  }
  public void setUltimateDebtor(UltimateDebtor ultimateDebtor) {
    this.ultimateDebtor = ultimateDebtor;
  }
  public RequestToPayInstruction instructedAmount(Double instructedAmount) {
    this.instructedAmount = instructedAmount;
    return this;
  }

  

  /**
  * Amount of money to be moved between debtor and creditor, before deduction of charges, expressed in the currency of the debtor&#x27;s account, and to be moved in a different currency.&lt;br/&gt;Format: minInclusive 0,totalDigits 18,fractionDigits 5
  * @return instructedAmount
  **/
  @Schema(required = true, description = "Amount of money to be moved between debtor and creditor, before deduction of charges, expressed in the currency of the debtor's account, and to be moved in a different currency.<br/>Format: minInclusive 0,totalDigits 18,fractionDigits 5")
  public Double getInstructedAmount() {
    return instructedAmount;
  }
  public void setInstructedAmount(Double instructedAmount) {
    this.instructedAmount = instructedAmount;
  }
  public RequestToPayInstruction chargeBearer(String chargeBearer) {
    this.chargeBearer = chargeBearer;
    return this;
  }

  

  /**
  * Specifies which party/parties will bear the charges associated with the processing of the payment transaction.&lt;br/&gt;Codeset: &lt;br/&gt;DEBT BorneByDebtor All transaction charges are to be borne by the debtor.&lt;br/&gt;CRED BorneByCreditor All transaction charges are to be borne by the creditor.&lt;br/&gt;SHAR Shared In a credit transfer context, means that transaction charges on the sender side are to be borne by the debtor,transaction charges on the receiver side are to be borne by the creditor. In a direct debit context, means that transaction charges on the sender side are to be borne by the creditor, transaction charges on the receiver side are to be borne by the debtor.&lt;br/&gt;SLEV FollowingServiceLevel Charges are to be applied following the rules agreed in the service level and/or scheme.
  * @return chargeBearer
  **/
  @Schema(example = "CRED", description = "Specifies which party/parties will bear the charges associated with the processing of the payment transaction.<br/>Codeset: <br/>DEBT BorneByDebtor All transaction charges are to be borne by the debtor.<br/>CRED BorneByCreditor All transaction charges are to be borne by the creditor.<br/>SHAR Shared In a credit transfer context, means that transaction charges on the sender side are to be borne by the debtor,transaction charges on the receiver side are to be borne by the creditor. In a direct debit context, means that transaction charges on the sender side are to be borne by the creditor, transaction charges on the receiver side are to be borne by the debtor.<br/>SLEV FollowingServiceLevel Charges are to be applied following the rules agreed in the service level and/or scheme.")
  public String getChargeBearer() {
    return chargeBearer;
  }
  public void setChargeBearer(String chargeBearer) {
    this.chargeBearer = chargeBearer;
  }
  public RequestToPayInstruction creditorAgent(CreditorAgent creditorAgent) {
    this.creditorAgent = creditorAgent;
    return this;
  }

  

  /**
  * Get creditorAgent
  * @return creditorAgent
  **/
  @Schema(description = "")
  public CreditorAgent getCreditorAgent() {
    return creditorAgent;
  }
  public void setCreditorAgent(CreditorAgent creditorAgent) {
    this.creditorAgent = creditorAgent;
  }
  public RequestToPayInstruction creditor(Creditor creditor) {
    this.creditor = creditor;
    return this;
  }

  

  /**
  * Get creditor
  * @return creditor
  **/
  @Schema(required = true, description = "")
  public Creditor getCreditor() {
    return creditor;
  }
  public void setCreditor(Creditor creditor) {
    this.creditor = creditor;
  }
  public RequestToPayInstruction ultimateCreditor(UltimateCreditor ultimateCreditor) {
    this.ultimateCreditor = ultimateCreditor;
    return this;
  }

  

  /**
  * Get ultimateCreditor
  * @return ultimateCreditor
  **/
  @Schema(description = "")
  public UltimateCreditor getUltimateCreditor() {
    return ultimateCreditor;
  }
  public void setUltimateCreditor(UltimateCreditor ultimateCreditor) {
    this.ultimateCreditor = ultimateCreditor;
  }
  public RequestToPayInstruction remittanceInformation(String remittanceInformation) {
    this.remittanceInformation = remittanceInformation;
    return this;
  }

  

  /**
  * Information supplied to enable the matching/reconciliation of an entry with the items that the payment is intended to settle, such as commercial invoices in an accounts&#x27; receivable system, in an unstructured form.
  * @return remittanceInformation
  **/
  @Schema(description = "Information supplied to enable the matching/reconciliation of an entry with the items that the payment is intended to settle, such as commercial invoices in an accounts' receivable system, in an unstructured form.")
  public String getRemittanceInformation() {
    return remittanceInformation;
  }
  public void setRemittanceInformation(String remittanceInformation) {
    this.remittanceInformation = remittanceInformation;
  }
  public RequestToPayInstruction additionalInformation(String additionalInformation) {
    this.additionalInformation = additionalInformation;
    return this;
  }

  

  /**
  * Additional information supplied to enable matching
  * @return additionalInformation
  **/
  @Schema(description = "Additional information supplied to enable matching")
  public String getAdditionalInformation() {
    return additionalInformation;
  }
  public void setAdditionalInformation(String additionalInformation) {
    this.additionalInformation = additionalInformation;
  }
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RequestToPayInstruction requestToPayInstruction = (RequestToPayInstruction) o;
    return Objects.equals(this.endToEndId, requestToPayInstruction.endToEndId) &&
        Objects.equals(this.paymentMethod, requestToPayInstruction.paymentMethod) &&
        Objects.equals(this.requestedExecutionDatetime, requestToPayInstruction.requestedExecutionDatetime) &&
        Objects.equals(this.initiatingParty, requestToPayInstruction.initiatingParty) &&
        Objects.equals(this.debtor, requestToPayInstruction.debtor) &&
        Objects.equals(this.debtorAgent, requestToPayInstruction.debtorAgent) &&
        Objects.equals(this.ultimateDebtor, requestToPayInstruction.ultimateDebtor) &&
        Objects.equals(this.instructedAmount, requestToPayInstruction.instructedAmount) &&
        Objects.equals(this.chargeBearer, requestToPayInstruction.chargeBearer) &&
        Objects.equals(this.creditorAgent, requestToPayInstruction.creditorAgent) &&
        Objects.equals(this.creditor, requestToPayInstruction.creditor) &&
        Objects.equals(this.ultimateCreditor, requestToPayInstruction.ultimateCreditor) &&
        Objects.equals(this.remittanceInformation, requestToPayInstruction.remittanceInformation) &&
        Objects.equals(this.additionalInformation, requestToPayInstruction.additionalInformation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(endToEndId, paymentMethod, requestedExecutionDatetime, initiatingParty, debtor, debtorAgent, ultimateDebtor, instructedAmount, chargeBearer, creditorAgent, creditor, ultimateCreditor, remittanceInformation, additionalInformation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RequestToPayInstruction {\n");
    
    sb.append("    endToEndId: ").append(toIndentedString(endToEndId)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    requestedExecutionDatetime: ").append(toIndentedString(requestedExecutionDatetime)).append("\n");
    sb.append("    initiatingParty: ").append(toIndentedString(initiatingParty)).append("\n");
    sb.append("    debtor: ").append(toIndentedString(debtor)).append("\n");
    sb.append("    debtorAgent: ").append(toIndentedString(debtorAgent)).append("\n");
    sb.append("    ultimateDebtor: ").append(toIndentedString(ultimateDebtor)).append("\n");
    sb.append("    instructedAmount: ").append(toIndentedString(instructedAmount)).append("\n");
    sb.append("    chargeBearer: ").append(toIndentedString(chargeBearer)).append("\n");
    sb.append("    creditorAgent: ").append(toIndentedString(creditorAgent)).append("\n");
    sb.append("    creditor: ").append(toIndentedString(creditor)).append("\n");
    sb.append("    ultimateCreditor: ").append(toIndentedString(ultimateCreditor)).append("\n");
    sb.append("    remittanceInformation: ").append(toIndentedString(remittanceInformation)).append("\n");
    sb.append("    additionalInformation: ").append(toIndentedString(additionalInformation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
