/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.model;

import ar.com.sdd.mboapi.model.ErrorResponseErrors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ErrorResponse {
    @JsonProperty(value="tracking_code")
    private String trackingCode = null;
    @JsonProperty(value="ref_id")
    private Object refId = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="http_code")
    private Integer httpCode = null;
    @JsonProperty(value="errors")
    private List<ErrorResponseErrors> errors = null;

    public ErrorResponse trackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
        return this;
    }

    @Schema(description="Unique Error tracking unique number (not an error Code)")
    public String getTrackingCode() {
        return this.trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }

    public ErrorResponse refId(Object refId) {
        this.refId = refId;
        return this;
    }

    @Schema(description="id assigned for every request initiated by client at api gateway layer [apim] which can be used for tracing purposes")
    public Object getRefId() {
        return this.refId;
    }

    public void setRefId(Object refId) {
        this.refId = refId;
    }

    public ErrorResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(description="Overall status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ErrorResponse httpCode(Integer httpCode) {
        this.httpCode = httpCode;
        return this;
    }

    @Schema(description="HTTP Error code: 200 for OK, 4xx 5xx for errors")
    public Integer getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(Integer httpCode) {
        this.httpCode = httpCode;
    }

    public ErrorResponse errors(List<ErrorResponseErrors> errors) {
        this.errors = errors;
        return this;
    }

    public ErrorResponse addErrorsItem(ErrorResponseErrors errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ErrorResponseErrors>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Schema(description="one enty with error description")
    public List<ErrorResponseErrors> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ErrorResponseErrors> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse errorResponse = (ErrorResponse)o;
        return Objects.equals(this.trackingCode, errorResponse.trackingCode) && Objects.equals(this.refId, errorResponse.refId) && Objects.equals((Object)this.status, (Object)errorResponse.status) && Objects.equals(this.httpCode, errorResponse.httpCode) && Objects.equals(this.errors, errorResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.trackingCode, this.refId, this.status, this.httpCode, this.errors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorResponse {\n");
        sb.append("    trackingCode: ").append(this.toIndentedString(this.trackingCode)).append("\n");
        sb.append("    refId: ").append(this.toIndentedString(this.refId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    httpCode: ").append(this.toIndentedString(this.httpCode)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

