package ar.com.sdd.mboapi.api.auth;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/mboapi/v1_0/auth")
public class AuthMboApiEndpoint {

    @Inject private AuthMboApiService authMboApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/token.oauth2")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postTokenOauth2(@PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        //POR DEFAULT, USAMOS LOGIN BY NAME
        return authMboApiService.postTokenOauth2(applicationId, ownerId, oauthCredentials, securityContext);
    }
}