package ar.com.sdd.mboapi.api.account;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.mboapi.model.Balance;
import ar.com.sdd.mboapi.model.RequestToPayInstruction;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/mboapi/v1_0/account")
public class AccountMboApiEndpoint {

    @Inject
    private AccountMboApiService accountMboApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/balance")
    @Produces("application/json; charset=utf-8")
    public Response getBankAccountsSearch(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, Balance balance, @Context SecurityContext securityContext) {
        return accountMboApiService.getBalance(authorization, applicationId, ownerId, balance, securityContext);
    }
}