/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class OAuth2Credential {
    @SerializedName(value="client_id")
    private String clientId = null;
    @SerializedName(value="client_secret")
    private String clientSecret = null;
    @SerializedName(value="grant_type")
    private String grantType = "client_credentials";

    public OAuth2Credential clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(example="citi_mboapi_svc", required=true, description="Client identifier (login name)")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuth2Credential clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Schema(example="3Vj5FRgTbBJPrerOaK7UtTCyr9nzRLPEjibrVQvBZI3eVcbDm", required=true, description="Client password (login password)")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuth2Credential grantType(String grantType) {
        this.grantType = grantType;
        return this;
    }

    @Schema(example="client_credentials", required=true, description="Access type")
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Credential oauth2Credential = (OAuth2Credential)o;
        return Objects.equals(this.clientId, oauth2Credential.clientId) && Objects.equals(this.clientSecret, oauth2Credential.clientSecret) && Objects.equals(this.grantType, oauth2Credential.grantType);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.grantType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Credential {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    grantType: ").append(this.toIndentedString(this.grantType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

