/*
 * MultiBalance API
 * MultiBalance Online API.
 *
 * OpenAPI spec version: 1.0.5
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package ar.com.sdd.mboapi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.IOException;
import java.util.Objects;
/**
 * Account details with currency and country
 */
@Schema(description = "Account details with currency and country")
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2022-03-08T19:03:50.221Z[GMT]")
public class AccountInfo {
  @SerializedName("name")
  private String name = null;

  @SerializedName("iban")
  private String iban = null;

  @SerializedName("account_id")
  private String accountId = null;

  @SerializedName("proxy_id")
  private String proxyId = null;

  /**
   * Identification of the currency in which the account is held.
   */
  @JsonAdapter(CurrencyEnum.Adapter.class)
  public enum CurrencyEnum {
    ARS("ARS"),
    USD("USD");

    private String value;

    CurrencyEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static CurrencyEnum fromValue(String input) {
      for (CurrencyEnum b : CurrencyEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<CurrencyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CurrencyEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public CurrencyEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return CurrencyEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("currency")
  private CurrencyEnum currency = null;

  @SerializedName("country")
  private String country = null;

  @SerializedName("organisation_id")
  private String organisationId = null;

  @SerializedName("organisation_code")
  private String organisationCode = null;

  @SerializedName("organisation_proprietary")
  private String organisationProprietary = null;

  @SerializedName("private_id")
  private String privateId = null;

  @SerializedName("private_code")
  private String privateCode = null;

  @SerializedName("private_proprietary")
  private String privateProprietary = null;

  public AccountInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name by which a party is known and which is usually used to identify that party. Not used.
   * @return name
  **/
  @Schema(description = "Name by which a party is known and which is usually used to identify that party. Not used.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AccountInfo iban(String iban) {
    this.iban = iban;
    return this;
  }

   /**
   * International Bank Account Number (IBAN) - identifier used internationally by financial institutions to uniquely identify the account of a customer. Further specifications of the format and content of the IBAN can be found in the standard ISO 13616 \&quot;Banking and related financial services - International Bank Account Number (IBAN)\&quot; version 1997-10-01, or later revisions. Not used.
   * @return iban
  **/
  @Schema(description = "International Bank Account Number (IBAN) - identifier used internationally by financial institutions to uniquely identify the account of a customer. Further specifications of the format and content of the IBAN can be found in the standard ISO 13616 \"Banking and related financial services - International Bank Account Number (IBAN)\" version 1997-10-01, or later revisions. Not used.")
  public String getIban() {
    return iban;
  }

  public void setIban(String iban) {
    this.iban = iban;
  }

  public AccountInfo accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Unique and unambiguous identification for the account between the account owner and the account servicer. Not used.
   * @return accountId
  **/
  @Schema(description = "Unique and unambiguous identification for the account between the account owner and the account servicer. Not used.")
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public AccountInfo proxyId(String proxyId) {
    this.proxyId = proxyId;
    return this;
  }

   /**
   * CBU for this account
   * @return proxyId
  **/
  @Schema(example = "0078888100008247960170", required = true, description = "CBU for this account")
  public String getProxyId() {
    return proxyId;
  }

  public void setProxyId(String proxyId) {
    this.proxyId = proxyId;
  }

  public AccountInfo currency(CurrencyEnum currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Identification of the currency in which the account is held.
   * @return currency
  **/
  @Schema(example = "ARS", description = "Identification of the currency in which the account is held.")
  public CurrencyEnum getCurrency() {
    return currency;
  }

  public void setCurrency(CurrencyEnum currency) {
    this.currency = currency;
  }

  public AccountInfo country(String country) {
    this.country = country;
    return this;
  }

   /**
   * Country in which a person resides (the place of a person&#x27;s home). In the case of a company, it is the country from which the affairs of that company are directed. Not used
   * @return country
  **/
  @Schema(example = "AR", description = "Country in which a person resides (the place of a person's home). In the case of a company, it is the country from which the affairs of that company are directed. Not used")
  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public AccountInfo organisationId(String organisationId) {
    this.organisationId = organisationId;
    return this;
  }

   /**
   * Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for debtor.
   * @return organisationId
  **/
  @Schema(example = "30-71234567-0", required = true, description = "Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for debtor.")
  public String getOrganisationId() {
    return organisationId;
  }

  public void setOrganisationId(String organisationId) {
    this.organisationId = organisationId;
  }

  public AccountInfo organisationCode(String organisationCode) {
    this.organisationCode = organisationCode;
    return this;
  }

   /**
   * Get organisationCode
   * @return organisationCode
  **/
  @Schema(description = "")
  public String getOrganisationCode() {
    return organisationCode;
  }

  public void setOrganisationCode(String organisationCode) {
    this.organisationCode = organisationCode;
  }

  public AccountInfo organisationProprietary(String organisationProprietary) {
    this.organisationProprietary = organisationProprietary;
    return this;
  }

   /**
   * Get organisationProprietary
   * @return organisationProprietary
  **/
  @Schema(description = "")
  public String getOrganisationProprietary() {
    return organisationProprietary;
  }

  public void setOrganisationProprietary(String organisationProprietary) {
    this.organisationProprietary = organisationProprietary;
  }

  public AccountInfo privateId(String privateId) {
    this.privateId = privateId;
    return this;
  }

   /**
   * Unique and unambiguous identification of a person, for example a passport, assigned by an institution
   * @return privateId
  **/
  @Schema(description = "Unique and unambiguous identification of a person, for example a passport, assigned by an institution")
  public String getPrivateId() {
    return privateId;
  }

  public void setPrivateId(String privateId) {
    this.privateId = privateId;
  }

  public AccountInfo privateCode(String privateCode) {
    this.privateCode = privateCode;
    return this;
  }

   /**
   * Get privateCode
   * @return privateCode
  **/
  @Schema(description = "")
  public String getPrivateCode() {
    return privateCode;
  }

  public void setPrivateCode(String privateCode) {
    this.privateCode = privateCode;
  }

  public AccountInfo privateProprietary(String privateProprietary) {
    this.privateProprietary = privateProprietary;
    return this;
  }

   /**
   * Get privateProprietary
   * @return privateProprietary
  **/
  @Schema(description = "")
  public String getPrivateProprietary() {
    return privateProprietary;
  }

  public void setPrivateProprietary(String privateProprietary) {
    this.privateProprietary = privateProprietary;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountInfo accountInfo = (AccountInfo) o;
    return Objects.equals(this.name, accountInfo.name) &&
        Objects.equals(this.iban, accountInfo.iban) &&
        Objects.equals(this.accountId, accountInfo.accountId) &&
        Objects.equals(this.proxyId, accountInfo.proxyId) &&
        Objects.equals(this.currency, accountInfo.currency) &&
        Objects.equals(this.country, accountInfo.country) &&
        Objects.equals(this.organisationId, accountInfo.organisationId) &&
        Objects.equals(this.organisationCode, accountInfo.organisationCode) &&
        Objects.equals(this.organisationProprietary, accountInfo.organisationProprietary) &&
        Objects.equals(this.privateId, accountInfo.privateId) &&
        Objects.equals(this.privateCode, accountInfo.privateCode) &&
        Objects.equals(this.privateProprietary, accountInfo.privateProprietary);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, iban, accountId, proxyId, currency, country, organisationId, organisationCode, organisationProprietary, privateId, privateCode, privateProprietary);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountInfo {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    proxyId: ").append(toIndentedString(proxyId)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    organisationId: ").append(toIndentedString(organisationId)).append("\n");
    sb.append("    organisationCode: ").append(toIndentedString(organisationCode)).append("\n");
    sb.append("    organisationProprietary: ").append(toIndentedString(organisationProprietary)).append("\n");
    sb.append("    privateId: ").append(toIndentedString(privateId)).append("\n");
    sb.append("    privateCode: ").append(toIndentedString(privateCode)).append("\n");
    sb.append("    privateProprietary: ").append(toIndentedString(privateProprietary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
