/*
 * MultiBalance API
 * MultiBalance Online API.
 *
 * OpenAPI spec version: 1.0.5
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package ar.com.sdd.mboapi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
/**
 * Current Balance for one account
 */
@Schema(description = "Current Balance for one account")
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2022-03-08T19:03:50.221Z[GMT]")
public class Balance {
  @SerializedName("ref_id")
  private String refId = null;

  @SerializedName("accountIdentification")
  private String accountIdentification = null;

  @SerializedName("accountServicer")
  private String accountServicer = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("currency")
  private String currency = null;

  @SerializedName("balances")
  private List<BalanceBalances> balances = null;

  @SerializedName("identification")
  private BalanceIdentification identification = null;

  public Balance refId(String refId) {
    this.refId = refId;
    return this;
  }

   /**
   * reference id assigned for every request initiated by client at api gateway layer [apim] which can be used for tracing purposes&#x27;
   * @return refId
  **/
  @Schema(example = "123456789", description = "reference id assigned for every request initiated by client at api gateway layer [apim] which can be used for tracing purposes'")
  public String getRefId() {
    return refId;
  }

  public void setRefId(String refId) {
    this.refId = refId;
  }

  public Balance accountIdentification(String accountIdentification) {
    this.accountIdentification = accountIdentification;
    return this;
  }

   /**
   * CBU identifier for the requested account. Format: number(22)
   * @return accountIdentification
  **/
  @Schema(example = "0168888100008247960170", description = "CBU identifier for the requested account. Format: number(22)")
  public String getAccountIdentification() {
    return accountIdentification;
  }

  public void setAccountIdentification(String accountIdentification) {
    this.accountIdentification = accountIdentification;
  }

  public Balance accountServicer(String accountServicer) {
    this.accountServicer = accountServicer;
    return this;
  }

   /**
   * Swift Bank code associated to CBU identifier
   * @return accountServicer
  **/
  @Schema(example = "CITIARBA", description = "Swift Bank code associated to CBU identifier")
  public String getAccountServicer() {
    return accountServicer;
  }

  public void setAccountServicer(String accountServicer) {
    this.accountServicer = accountServicer;
  }

  public Balance name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Tax ID of the account, or name of the account if provided
   * @return name
  **/
  @Schema(example = "0168888100008247960170", description = "Tax ID of the account, or name of the account if provided")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Balance currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * ISO currency Code (ARS/USD)
   * @return currency
  **/
  @Schema(example = "ARS", description = "ISO currency Code (ARS/USD)")
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Balance balances(List<BalanceBalances> balances) {
    this.balances = balances;
    return this;
  }

  public Balance addBalancesItem(BalanceBalances balancesItem) {
    if (this.balances == null) {
      this.balances = new ArrayList<BalanceBalances>();
    }
    this.balances.add(balancesItem);
    return this;
  }

   /**
   * List of balances available for the query.Only currentBalance will be included.
   * @return balances
  **/
  @Schema(description = "List of balances available for the query.Only currentBalance will be included.")
  public List<BalanceBalances> getBalances() {
    return balances;
  }

  public void setBalances(List<BalanceBalances> balances) {
    this.balances = balances;
  }

  public Balance identification(BalanceIdentification identification) {
    this.identification = identification;
    return this;
  }

   /**
   * Get identification
   * @return identification
  **/
  @Schema(description = "")
  public BalanceIdentification getIdentification() {
    return identification;
  }

  public void setIdentification(BalanceIdentification identification) {
    this.identification = identification;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Balance balance = (Balance) o;
    return Objects.equals(this.refId, balance.refId) &&
        Objects.equals(this.accountIdentification, balance.accountIdentification) &&
        Objects.equals(this.accountServicer, balance.accountServicer) &&
        Objects.equals(this.name, balance.name) &&
        Objects.equals(this.currency, balance.currency) &&
        Objects.equals(this.balances, balance.balances) &&
        Objects.equals(this.identification, balance.identification);
  }

  @Override
  public int hashCode() {
    return Objects.hash(refId, accountIdentification, accountServicer, name, currency, balances, identification);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Balance {\n");
    
    sb.append("    refId: ").append(toIndentedString(refId)).append("\n");
    sb.append("    accountIdentification: ").append(toIndentedString(accountIdentification)).append("\n");
    sb.append("    accountServicer: ").append(toIndentedString(accountServicer)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    balances: ").append(toIndentedString(balances)).append("\n");
    sb.append("    identification: ").append(toIndentedString(identification)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
