/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Account details with currency and country")
public class AccountInfo {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="iban")
    private String iban = null;
    @SerializedName(value="account_id")
    private String accountId = null;
    @SerializedName(value="proxy_id")
    private String proxyId = null;
    @SerializedName(value="currency")
    private CurrencyEnum currency = null;
    @SerializedName(value="country")
    private String country = null;
    @SerializedName(value="organisation_id")
    private String organisationId = null;
    @SerializedName(value="organisation_code")
    private String organisationCode = null;
    @SerializedName(value="organisation_proprietary")
    private String organisationProprietary = null;
    @SerializedName(value="private_id")
    private String privateId = null;
    @SerializedName(value="private_code")
    private String privateCode = null;
    @SerializedName(value="private_proprietary")
    private String privateProprietary = null;

    public AccountInfo name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name by which a party is known and which is usually used to identify that party. Not used.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccountInfo iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Schema(description="International Bank Account Number (IBAN) - identifier used internationally by financial institutions to uniquely identify the account of a customer. Further specifications of the format and content of the IBAN can be found in the standard ISO 13616 \"Banking and related financial services - International Bank Account Number (IBAN)\" version 1997-10-01, or later revisions. Not used.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public AccountInfo accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="Unique and unambiguous identification for the account between the account owner and the account servicer. Not used.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AccountInfo proxyId(String proxyId) {
        this.proxyId = proxyId;
        return this;
    }

    @Schema(example="0078888100008247960170", required=true, description="CBU for this account")
    public String getProxyId() {
        return this.proxyId;
    }

    public void setProxyId(String proxyId) {
        this.proxyId = proxyId;
    }

    public AccountInfo currency(CurrencyEnum currency) {
        this.currency = currency;
        return this;
    }

    @Schema(example="ARS", description="Identification of the currency in which the account is held.")
    public CurrencyEnum getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyEnum currency) {
        this.currency = currency;
    }

    public AccountInfo country(String country) {
        this.country = country;
        return this;
    }

    @Schema(example="AR", description="Country in which a person resides (the place of a person's home). In the case of a company, it is the country from which the affairs of that company are directed. Not used")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public AccountInfo organisationId(String organisationId) {
        this.organisationId = organisationId;
        return this;
    }

    @Schema(example="30-71234567-0", required=true, description="Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for debtor.")
    public String getOrganisationId() {
        return this.organisationId;
    }

    public void setOrganisationId(String organisationId) {
        this.organisationId = organisationId;
    }

    public AccountInfo organisationCode(String organisationCode) {
        this.organisationCode = organisationCode;
        return this;
    }

    @Schema(description="")
    public String getOrganisationCode() {
        return this.organisationCode;
    }

    public void setOrganisationCode(String organisationCode) {
        this.organisationCode = organisationCode;
    }

    public AccountInfo organisationProprietary(String organisationProprietary) {
        this.organisationProprietary = organisationProprietary;
        return this;
    }

    @Schema(description="")
    public String getOrganisationProprietary() {
        return this.organisationProprietary;
    }

    public void setOrganisationProprietary(String organisationProprietary) {
        this.organisationProprietary = organisationProprietary;
    }

    public AccountInfo privateId(String privateId) {
        this.privateId = privateId;
        return this;
    }

    @Schema(description="Unique and unambiguous identification of a person, for example a passport, assigned by an institution")
    public String getPrivateId() {
        return this.privateId;
    }

    public void setPrivateId(String privateId) {
        this.privateId = privateId;
    }

    public AccountInfo privateCode(String privateCode) {
        this.privateCode = privateCode;
        return this;
    }

    @Schema(description="")
    public String getPrivateCode() {
        return this.privateCode;
    }

    public void setPrivateCode(String privateCode) {
        this.privateCode = privateCode;
    }

    public AccountInfo privateProprietary(String privateProprietary) {
        this.privateProprietary = privateProprietary;
        return this;
    }

    @Schema(description="")
    public String getPrivateProprietary() {
        return this.privateProprietary;
    }

    public void setPrivateProprietary(String privateProprietary) {
        this.privateProprietary = privateProprietary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountInfo accountInfo = (AccountInfo)o;
        return Objects.equals(this.name, accountInfo.name) && Objects.equals(this.iban, accountInfo.iban) && Objects.equals(this.accountId, accountInfo.accountId) && Objects.equals(this.proxyId, accountInfo.proxyId) && Objects.equals((Object)this.currency, (Object)accountInfo.currency) && Objects.equals(this.country, accountInfo.country) && Objects.equals(this.organisationId, accountInfo.organisationId) && Objects.equals(this.organisationCode, accountInfo.organisationCode) && Objects.equals(this.organisationProprietary, accountInfo.organisationProprietary) && Objects.equals(this.privateId, accountInfo.privateId) && Objects.equals(this.privateCode, accountInfo.privateCode) && Objects.equals(this.privateProprietary, accountInfo.privateProprietary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.iban, this.accountId, this.proxyId, this.currency, this.country, this.organisationId, this.organisationCode, this.organisationProprietary, this.privateId, this.privateCode, this.privateProprietary});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountInfo {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    proxyId: ").append(this.toIndentedString(this.proxyId)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    organisationId: ").append(this.toIndentedString(this.organisationId)).append("\n");
        sb.append("    organisationCode: ").append(this.toIndentedString(this.organisationCode)).append("\n");
        sb.append("    organisationProprietary: ").append(this.toIndentedString(this.organisationProprietary)).append("\n");
        sb.append("    privateId: ").append(this.toIndentedString(this.privateId)).append("\n");
        sb.append("    privateCode: ").append(this.toIndentedString(this.privateCode)).append("\n");
        sb.append("    privateProprietary: ").append(this.toIndentedString(this.privateProprietary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CurrencyEnum {
        ARS("ARS"),
        USD("USD");

        private String value;

        private CurrencyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CurrencyEnum fromValue(String input) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CurrencyEnum> {
            public void write(JsonWriter jsonWriter, CurrencyEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public CurrencyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CurrencyEnum.fromValue(value);
            }
        }
    }
}

