/*
 * MultiBalance API
 * MultiBalance Online API.
 *
 * OpenAPI spec version: 1.0.5
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package ar.com.sdd.mboapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
/**
 * ErrorResponse
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2022-03-08T19:03:50.221Z[GMT]")
public class ErrorResponse implements Serializable {
  @JsonProperty("trackingCode")
  private String trackingCode = null;

  @JsonProperty("ref_id")
  private Object refId = null;

  /**
   * Overall status
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    SUCCESS("SUCCESS"),
    FAILURE("FAILURE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static StatusEnum fromValue(String input) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return StatusEnum.fromValue((String)(value));
      }
    }
  }  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("httpCode")
  private Integer httpCode = null;

  @JsonProperty("errors")
  private List<ErrorResponseErrors> errors = null;

  public ErrorResponse trackingCode(String trackingCode) {
    this.trackingCode = trackingCode;
    return this;
  }

   /**
   * Unique Error tracking unique number (not an error Code)
   * @return trackingCode
  **/
  @Schema(description = "Unique Error tracking unique number (not an error Code)")
  public String getTrackingCode() {
    return trackingCode;
  }

  public void setTrackingCode(String trackingCode) {
    this.trackingCode = trackingCode;
  }

  public ErrorResponse refId(Object refId) {
    this.refId = refId;
    return this;
  }

   /**
   * id assigned for every request initiated by client at api gateway layer [apim] which can be used for tracing purposes
   * @return refId
  **/
  @Schema(description = "id assigned for every request initiated by client at api gateway layer [apim] which can be used for tracing purposes")
  public Object getRefId() {
    return refId;
  }

  public void setRefId(Object refId) {
    this.refId = refId;
  }

  public ErrorResponse status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Overall status
   * @return status
  **/
  @Schema(description = "Overall status")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public ErrorResponse httpCode(Integer httpCode) {
    this.httpCode = httpCode;
    return this;
  }

   /**
   * HTTP Error code: 200 for OK, 4xx 5xx for errors
   * @return httpCode
  **/
  @Schema(description = "HTTP Error code: 200 for OK, 4xx 5xx for errors")
  public Integer getHttpCode() {
    return httpCode;
  }

  public void setHttpCode(Integer httpCode) {
    this.httpCode = httpCode;
  }

  public ErrorResponse errors(List<ErrorResponseErrors> errors) {
    this.errors = errors;
    return this;
  }

  public ErrorResponse addErrorsItem(ErrorResponseErrors errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<ErrorResponseErrors>();
    }
    this.errors.add(errorsItem);
    return this;
  }

   /**
   * one enty with error description
   * @return errors
  **/
  @Schema(description = "one enty with error description")
  public List<ErrorResponseErrors> getErrors() {
    return errors;
  }

  public void setErrors(List<ErrorResponseErrors> errors) {
    this.errors = errors;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ErrorResponse errorResponse = (ErrorResponse) o;
    return Objects.equals(this.trackingCode, errorResponse.trackingCode) &&
        Objects.equals(this.refId, errorResponse.refId) &&
        Objects.equals(this.status, errorResponse.status) &&
        Objects.equals(this.httpCode, errorResponse.httpCode) &&
        Objects.equals(this.errors, errorResponse.errors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(trackingCode, refId, status, httpCode, errors);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ErrorResponse {\n");
    
    sb.append("    trackingCode: ").append(toIndentedString(trackingCode)).append("\n");
    sb.append("    refId: ").append(toIndentedString(refId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    httpCode: ").append(toIndentedString(httpCode)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
