/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

public class TokenOAuth2
implements Serializable {
    @JsonProperty(value="access_token")
    private String accessToken = null;
    @JsonProperty(value="token_type")
    private String tokenType = null;
    @JsonProperty(value="expires_in")
    private Integer expiresIn = null;

    public TokenOAuth2 accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Schema(example="MoV31GV-amEWpzwE_1_n4TpiY14zVJkNelJhVxz9yg7rEJe7Yl", description="Returned access token")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TokenOAuth2 tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Schema(example="Bearer", description="Type of token (Bearer)")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public TokenOAuth2 expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Schema(example="86400", description="Expiration time in seconds")
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenOAuth2 tokenOAuth2 = (TokenOAuth2)o;
        return Objects.equals(this.accessToken, tokenOAuth2.accessToken) && Objects.equals(this.tokenType, tokenOAuth2.tokenType) && Objects.equals(this.expiresIn, tokenOAuth2.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.expiresIn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenOAuth2 {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

