/*
 * MultiBalance API
 * MultiBalance Online API.
 *
 * OpenAPI spec version: 1.0.5
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package ar.com.sdd.mboapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class RequestToPayResponse implements Serializable {

    @JsonProperty("trackingCode")
    private String trackingCode = null;

    /**
     * Overall status
     */
    @JsonAdapter(StatusEnum.Adapter.class)
    public enum StatusEnum {
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static StatusEnum fromValue(String input) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return null;
        }

        public static class Adapter extends TypeAdapter<StatusEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public StatusEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return StatusEnum.fromValue((String) (value));
            }
        }
    }

    @JsonProperty("status")
    private StatusEnum status = null;

    @JsonProperty("httpCode")
    private Integer httpCode = null;

    @JsonProperty("errors")
    private List<ErrorResponseErrors> errors = null;

    @JsonProperty("end_to_end_id")
    private String endToEndId = null;

    public RequestToPayResponse trackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
        return this;
    }

    /**
     * Unique Error tracking unique number (not an error Code)
     *
     * @return trackingCode
     **/
    @Schema(description = "Unique Error tracking unique number (not an error Code)")
    public String getTrackingCode() {
        return trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }

    public RequestToPayResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    /**
     * Overall status
     *
     * @return status
     **/
    @Schema(description = "Overall status")
    public StatusEnum getStatus() {
        return status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public RequestToPayResponse httpCode(Integer httpCode) {
        this.httpCode = httpCode;
        return this;
    }

    /**
     * HTTP Error code: 200 for OK, 4xx 5xx for errors
     *
     * @return httpCode
     **/
    @Schema(description = "HTTP Error code: 200 for OK, 4xx 5xx for errors")
    public Integer getHttpCode() {
        return httpCode;
    }

    public void setHttpCode(Integer httpCode) {
        this.httpCode = httpCode;
    }

    public RequestToPayResponse errors(List<ErrorResponseErrors> errors) {
        this.errors = errors;
        return this;
    }

    public RequestToPayResponse addErrorsItem(ErrorResponseErrors errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ErrorResponseErrors>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    /**
     * one enty with error description
     *
     * @return errors
     **/
    @Schema(description = "one enty with error description")
    public List<ErrorResponseErrors> getErrors() {
        return errors;
    }

    public void setErrors(List<ErrorResponseErrors> errors) {
        this.errors = errors;
    }

    public String getEndToEndId() {
        return endToEndId;
    }

    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RequestToPayResponse that = (RequestToPayResponse) o;
        return Objects.equals(trackingCode, that.trackingCode) && status == that.status && Objects.equals(httpCode, that.httpCode) && Objects.equals(errors, that.errors) && Objects.equals(endToEndId, that.endToEndId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingCode, status, httpCode, errors, endToEndId);
    }

    @Override
    public String toString() {
        return "RequestToPayResponse ["
                + ((trackingCode != null) ? "trackingCode=" + trackingCode + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((httpCode != null) ? "httpCode=" + httpCode + ", " : "")
                + ((errors != null) ? "errors=" + Arrays.toString(errors.toArray()) + ", " : "")
                + ((endToEndId != null) ? "endToEndId=" + endToEndId : "")
                + "]";
    }
}