/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.model;

import ar.com.sdd.mboapi.model.BalanceBalances;
import ar.com.sdd.mboapi.model.BalanceIdentification;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Current Balance for one account")
public class Balance
implements Serializable {
    @JsonProperty(value="ref_id")
    private String refId = null;
    @JsonProperty(value="accountIdentification")
    private String accountIdentification = null;
    @JsonProperty(value="accountServicer")
    private String accountServicer = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="balances")
    private List<BalanceBalances> balances = null;
    @JsonProperty(value="identification")
    private BalanceIdentification identification = null;

    public Balance refId(String refId) {
        this.refId = refId;
        return this;
    }

    @Schema(example="123456789", description="reference id assigned for every request initiated by client at api gateway layer [apim] which can be used for tracing purposes'")
    public String getRefId() {
        return this.refId;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public Balance accountIdentification(String accountIdentification) {
        this.accountIdentification = accountIdentification;
        return this;
    }

    @Schema(example="0168888100008247960170", description="CBU identifier for the requested account. Format: number(22)")
    public String getAccountIdentification() {
        return this.accountIdentification;
    }

    public void setAccountIdentification(String accountIdentification) {
        this.accountIdentification = accountIdentification;
    }

    public Balance accountServicer(String accountServicer) {
        this.accountServicer = accountServicer;
        return this;
    }

    @Schema(example="CITIARBA", description="Swift Bank code associated to CBU identifier")
    public String getAccountServicer() {
        return this.accountServicer;
    }

    public void setAccountServicer(String accountServicer) {
        this.accountServicer = accountServicer;
    }

    public Balance name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="0168888100008247960170", description="Tax ID of the account, or name of the account if provided")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Balance currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Schema(example="ARS", description="ISO currency Code (ARS/USD)")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Balance balances(List<BalanceBalances> balances) {
        this.balances = balances;
        return this;
    }

    public Balance addBalancesItem(BalanceBalances balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<BalanceBalances>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @Schema(description="List of balances available for the query.Only currentBalance will be included.")
    public List<BalanceBalances> getBalances() {
        return this.balances;
    }

    public void setBalances(List<BalanceBalances> balances) {
        this.balances = balances;
    }

    public Balance identification(BalanceIdentification identification) {
        this.identification = identification;
        return this;
    }

    @Schema(description="")
    public BalanceIdentification getIdentification() {
        return this.identification;
    }

    public void setIdentification(BalanceIdentification identification) {
        this.identification = identification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance balance = (Balance)o;
        return Objects.equals(this.refId, balance.refId) && Objects.equals(this.accountIdentification, balance.accountIdentification) && Objects.equals(this.accountServicer, balance.accountServicer) && Objects.equals(this.name, balance.name) && Objects.equals(this.currency, balance.currency) && Objects.equals(this.balances, balance.balances) && Objects.equals(this.identification, balance.identification);
    }

    public int hashCode() {
        return Objects.hash(this.refId, this.accountIdentification, this.accountServicer, this.name, this.currency, this.balances, this.identification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Balance {\n");
        sb.append("    refId: ").append(this.toIndentedString(this.refId)).append("\n");
        sb.append("    accountIdentification: ").append(this.toIndentedString(this.accountIdentification)).append("\n");
        sb.append("    accountServicer: ").append(this.toIndentedString(this.accountServicer)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

