/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.model;

import ar.com.sdd.mboapi.model.Reason;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Response to payment API allows vendor to create request credit payment to citi accounts from their external accounts")
public class PaymentStatusNotification
implements Serializable {
    @JsonProperty(value="original_end_to_end_id")
    private String originalEndToEndId = null;
    @JsonProperty(value="issuing_party_identifier")
    private String issuingPartyIdentifier = null;
    @JsonProperty(value="transaction_status")
    private TransactionStatusEnum transactionStatus = null;
    @JsonProperty(value="reason")
    private Reason reason = null;
    @JsonProperty(value="accepted_amount")
    private Double acceptedAmount = null;
    @JsonProperty(value="debtor_decision_date_time")
    private String debtorDecisionDateTime = null;
    @JsonProperty(value="acceptance_date_time")
    private String acceptanceDateTime = null;
    @JsonProperty(value="account_servicer_reference")
    private String accountServicerReference = null;
    @JsonProperty(value="clearing_system_reference")
    private String clearingSystemReference = null;
    @JsonProperty(value="debtor_organisation_id")
    private String debtorOrganisationId = null;
    @JsonProperty(value="debtor_proxy_id")
    private String debtorProxyId = null;
    @JsonProperty(value="creditor_organisation_id")
    private String creditorOrganisationId = null;
    @JsonProperty(value="creditor_proxy_id")
    private String creditorProxyId = null;

    public PaymentStatusNotification originalEndToEndId(String originalEndToEndId) {
        this.originalEndToEndId = originalEndToEndId;
        return this;
    }

    @Schema(required=true, description="Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain")
    public String getOriginalEndToEndId() {
        return this.originalEndToEndId;
    }

    public void setOriginalEndToEndId(String originalEndToEndId) {
        this.originalEndToEndId = originalEndToEndId;
    }

    public PaymentStatusNotification issuingPartyIdentifier(String issuingPartyIdentifier) {
        this.issuingPartyIdentifier = issuingPartyIdentifier;
        return this;
    }

    @Schema(description="Party that issues the status (Unique and unambiguous identification of a financial institution, as assigned under an internationally recognised or proprietary identification scheme). BIC - Format pattern [A-Z0-9]{4,4}[A-Z]{2,2}[A-Z0-9]{2,2}([A-Z0-9]{3,3}){0,1}")
    public String getIssuingPartyIdentifier() {
        return this.issuingPartyIdentifier;
    }

    public void setIssuingPartyIdentifier(String issuingPartyIdentifier) {
        this.issuingPartyIdentifier = issuingPartyIdentifier;
    }

    public PaymentStatusNotification transactionStatus(TransactionStatusEnum transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @Schema(required=true, description="Specifies the status of a transaction, in a coded form")
    public TransactionStatusEnum getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatusEnum transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public PaymentStatusNotification reason(Reason reason) {
        this.reason = reason;
        return this;
    }

    @Schema(description="")
    public Reason getReason() {
        return this.reason;
    }

    public void setReason(Reason reason) {
        this.reason = reason;
    }

    public PaymentStatusNotification acceptedAmount(Double acceptedAmount) {
        this.acceptedAmount = acceptedAmount;
        return this;
    }

    @Schema(description="Amount accepted to be paid. Format: minInclusive 0,totalDigits 18,fractionDigits 5")
    public Double getAcceptedAmount() {
        return this.acceptedAmount;
    }

    public void setAcceptedAmount(Double acceptedAmount) {
        this.acceptedAmount = acceptedAmount;
    }

    public PaymentStatusNotification debtorDecisionDateTime(String debtorDecisionDateTime) {
        this.debtorDecisionDateTime = debtorDecisionDateTime;
        return this;
    }

    @Schema(example="2016-06-23T09:07:21.205-07:00", description="Date and time on when the debtor has accepted or rejected the request<br/> UTC offset format (YYYY-MM-DDThh:mm:ss.sss+/-hh:mm) <br/>Note on the time format: 1) beginning / end of calendar day 00:00:00 = the beginning of a calendar day 24:00:00 = the end of a calendar day 2) fractions of second in time format Decimal fractions of seconds may be included. In this case, the involved parties shall agree on the maximum number of digits that are allowed.")
    public String getDebtorDecisionDateTime() {
        return this.debtorDecisionDateTime;
    }

    public void setDebtorDecisionDateTime(String debtorDecisionDateTime) {
        this.debtorDecisionDateTime = debtorDecisionDateTime;
    }

    public PaymentStatusNotification acceptanceDateTime(String acceptanceDateTime) {
        this.acceptanceDateTime = acceptanceDateTime;
        return this;
    }

    @Schema(example="2016-06-23T09:07:21.205-07:00", description="Point in time when the payment order from the initiating party meets the processing conditions of the account servicing agent. This means that the account servicing agent has received the payment order and has applied checks such as authorisation, availability of funds<br/> UTC offset format (YYYY-MM-DDThh:mm:ss.sss+/-hh:mm) <br/>Note on the time format: 1) beginning / end of calendar day 00:00:00 = the beginning of a calendar day 24:00:00 = the end of a calendar day 2) fractions of second in time format Decimal fractions of seconds may be included. In this case, the involved parties shall agree on the maximum number of digits that are allowed.")
    public String getAcceptanceDateTime() {
        return this.acceptanceDateTime;
    }

    public void setAcceptanceDateTime(String acceptanceDateTime) {
        this.acceptanceDateTime = acceptanceDateTime;
    }

    public PaymentStatusNotification accountServicerReference(String accountServicerReference) {
        this.accountServicerReference = accountServicerReference;
        return this;
    }

    @Schema(example="76V4MR2ZPZZ4G8Y9DEZOL1", description="Unique reference, as assigned by the account servicing institution, to unambiguously identify the instruction. (Debin ID)")
    public String getAccountServicerReference() {
        return this.accountServicerReference;
    }

    public void setAccountServicerReference(String accountServicerReference) {
        this.accountServicerReference = accountServicerReference;
    }

    public PaymentStatusNotification clearingSystemReference(String clearingSystemReference) {
        this.clearingSystemReference = clearingSystemReference;
        return this;
    }

    @Schema(description="Unique reference, as assigned by a clearing system, to unambiguously identify the instruction. (SDD ID)")
    public String getClearingSystemReference() {
        return this.clearingSystemReference;
    }

    public void setClearingSystemReference(String clearingSystemReference) {
        this.clearingSystemReference = clearingSystemReference;
    }

    public PaymentStatusNotification debtorOrganisationId(String debtorOrganisationId) {
        this.debtorOrganisationId = debtorOrganisationId;
        return this;
    }

    @Schema(example="30-71234567-0", description="Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for debtor.")
    public String getDebtorOrganisationId() {
        return this.debtorOrganisationId;
    }

    public void setDebtorOrganisationId(String debtorOrganisationId) {
        this.debtorOrganisationId = debtorOrganisationId;
    }

    public PaymentStatusNotification debtorProxyId(String debtorProxyId) {
        this.debtorProxyId = debtorProxyId;
        return this;
    }

    @Schema(example="0078888100008247960170", description="CBU for debit 3RD PARTY account")
    public String getDebtorProxyId() {
        return this.debtorProxyId;
    }

    public void setDebtorProxyId(String debtorProxyId) {
        this.debtorProxyId = debtorProxyId;
    }

    public PaymentStatusNotification creditorOrganisationId(String creditorOrganisationId) {
        this.creditorOrganisationId = creditorOrganisationId;
        return this;
    }

    @Schema(example="30-71234567-0", description="Unique and unambiguous way to identify an organisation assigned by an institution. TAXID/CUIT for creditor.")
    public String getCreditorOrganisationId() {
        return this.creditorOrganisationId;
    }

    public void setCreditorOrganisationId(String creditorOrganisationId) {
        this.creditorOrganisationId = creditorOrganisationId;
    }

    public PaymentStatusNotification creditorProxyId(String creditorProxyId) {
        this.creditorProxyId = creditorProxyId;
        return this;
    }

    @Schema(example="0168888100008247960170", description="CBU for credit account.")
    public String getCreditorProxyId() {
        return this.creditorProxyId;
    }

    public void setCreditorProxyId(String creditorProxyId) {
        this.creditorProxyId = creditorProxyId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentStatusNotification paymentStatusNotification = (PaymentStatusNotification)o;
        return Objects.equals(this.originalEndToEndId, paymentStatusNotification.originalEndToEndId) && Objects.equals(this.issuingPartyIdentifier, paymentStatusNotification.issuingPartyIdentifier) && Objects.equals((Object)this.transactionStatus, (Object)paymentStatusNotification.transactionStatus) && Objects.equals(this.reason, paymentStatusNotification.reason) && Objects.equals(this.acceptedAmount, paymentStatusNotification.acceptedAmount) && Objects.equals(this.debtorDecisionDateTime, paymentStatusNotification.debtorDecisionDateTime) && Objects.equals(this.acceptanceDateTime, paymentStatusNotification.acceptanceDateTime) && Objects.equals(this.accountServicerReference, paymentStatusNotification.accountServicerReference) && Objects.equals(this.clearingSystemReference, paymentStatusNotification.clearingSystemReference) && Objects.equals(this.debtorOrganisationId, paymentStatusNotification.debtorOrganisationId) && Objects.equals(this.debtorProxyId, paymentStatusNotification.debtorProxyId) && Objects.equals(this.creditorOrganisationId, paymentStatusNotification.creditorOrganisationId) && Objects.equals(this.creditorProxyId, paymentStatusNotification.creditorProxyId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.originalEndToEndId, this.issuingPartyIdentifier, this.transactionStatus, this.reason, this.acceptedAmount, this.debtorDecisionDateTime, this.acceptanceDateTime, this.accountServicerReference, this.clearingSystemReference, this.debtorOrganisationId, this.debtorProxyId, this.creditorOrganisationId, this.creditorProxyId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentStatusNotification {\n");
        sb.append("    originalEndToEndId: ").append(this.toIndentedString(this.originalEndToEndId)).append("\n");
        sb.append("    issuingPartyIdentifier: ").append(this.toIndentedString(this.issuingPartyIdentifier)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString((Object)this.transactionStatus)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    acceptedAmount: ").append(this.toIndentedString(this.acceptedAmount)).append("\n");
        sb.append("    debtorDecisionDateTime: ").append(this.toIndentedString(this.debtorDecisionDateTime)).append("\n");
        sb.append("    acceptanceDateTime: ").append(this.toIndentedString(this.acceptanceDateTime)).append("\n");
        sb.append("    accountServicerReference: ").append(this.toIndentedString(this.accountServicerReference)).append("\n");
        sb.append("    clearingSystemReference: ").append(this.toIndentedString(this.clearingSystemReference)).append("\n");
        sb.append("    debtorOrganisationId: ").append(this.toIndentedString(this.debtorOrganisationId)).append("\n");
        sb.append("    debtorProxyId: ").append(this.toIndentedString(this.debtorProxyId)).append("\n");
        sb.append("    creditorOrganisationId: ").append(this.toIndentedString(this.creditorOrganisationId)).append("\n");
        sb.append("    creditorProxyId: ").append(this.toIndentedString(this.creditorProxyId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionStatusEnum {
        ACSC_ACCEPTED_("{\"ACCC\":\"accepted\"}"),
        RJCT_REJECTED_("{\"RJCT\":\"rejected\"}");

        private String value;

        private TransactionStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionStatusEnum fromValue(String input) {
            for (TransactionStatusEnum b : TransactionStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TransactionStatusEnum> {
            public void write(JsonWriter jsonWriter, TransactionStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TransactionStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionStatusEnum.fromValue(value);
            }
        }
    }
}

