/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.model;

import ar.com.sdd.mboapi.model.Creditor;
import ar.com.sdd.mboapi.model.CreditorAgent;
import ar.com.sdd.mboapi.model.Debtor;
import ar.com.sdd.mboapi.model.DebtorAgent;
import ar.com.sdd.mboapi.model.InitiatingParty;
import ar.com.sdd.mboapi.model.UltimateCreditor;
import ar.com.sdd.mboapi.model.UltimateDebtor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestToPayInstruction
implements Serializable {
    @JsonProperty(value="end_to_end_id")
    private String endToEndId = null;
    @JsonProperty(value="payment_method")
    private String paymentMethod = null;
    @JsonProperty(value="requested_execution_datetime")
    private String requestedExecutionDatetime = null;
    @JsonProperty(value="initiating_party")
    private InitiatingParty initiatingParty = null;
    @JsonProperty(value="debtor")
    private Debtor debtor = null;
    @JsonProperty(value="debtor_agent")
    private DebtorAgent debtorAgent = null;
    @JsonProperty(value="ultimate_debtor")
    private UltimateDebtor ultimateDebtor = null;
    @JsonProperty(value="instructed_amount")
    private Double instructedAmount = null;
    @JsonProperty(value="charge_bearer")
    private String chargeBearer = null;
    @JsonProperty(value="creditor_agent")
    private CreditorAgent creditorAgent = null;
    @JsonProperty(value="creditor")
    private Creditor creditor = null;
    @JsonProperty(value="ultimate_creditor")
    private UltimateCreditor ultimateCreditor = null;
    @JsonProperty(value="remittance_information")
    private String remittanceInformation = null;
    @JsonProperty(value="additional_information")
    private String additionalInformation = null;

    public RequestToPayInstruction endToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
        return this;
    }

    @Schema(required=true, description="Unique identification assigned by the initiating party to unambiguously identify the transaction")
    public String getEndToEndId() {
        return this.endToEndId;
    }

    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    public RequestToPayInstruction paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(example="TRF", description="Specifies the means of payment that will be used to move the amount of money.Not used.Only can be TRF")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public RequestToPayInstruction requestedExecutionDatetime(String requestedExecutionDatetime) {
        this.requestedExecutionDatetime = requestedExecutionDatetime;
        return this;
    }

    @Schema(example="2016-06-23T09:07:21.205-07:00", description="Date at which the initiating party requests the clearing agent to process the payment. If payment by cheque, the date when the cheque must be generated by the bank. Not used.Should be empty or NOW")
    public String getRequestedExecutionDatetime() {
        return this.requestedExecutionDatetime;
    }

    public void setRequestedExecutionDatetime(String requestedExecutionDatetime) {
        this.requestedExecutionDatetime = requestedExecutionDatetime;
    }

    public RequestToPayInstruction initiatingParty(InitiatingParty initiatingParty) {
        this.initiatingParty = initiatingParty;
        return this;
    }

    @Schema(description="")
    public InitiatingParty getInitiatingParty() {
        return this.initiatingParty;
    }

    public void setInitiatingParty(InitiatingParty initiatingParty) {
        this.initiatingParty = initiatingParty;
    }

    public RequestToPayInstruction debtor(Debtor debtor) {
        this.debtor = debtor;
        return this;
    }

    @Schema(required=true, description="")
    public Debtor getDebtor() {
        return this.debtor;
    }

    public void setDebtor(Debtor debtor) {
        this.debtor = debtor;
    }

    public RequestToPayInstruction debtorAgent(DebtorAgent debtorAgent) {
        this.debtorAgent = debtorAgent;
        return this;
    }

    @Schema(description="")
    public DebtorAgent getDebtorAgent() {
        return this.debtorAgent;
    }

    public void setDebtorAgent(DebtorAgent debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public RequestToPayInstruction ultimateDebtor(UltimateDebtor ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
        return this;
    }

    @Schema(description="")
    public UltimateDebtor getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public void setUltimateDebtor(UltimateDebtor ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public RequestToPayInstruction instructedAmount(Double instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @Schema(required=true, description="Amount of money to be moved between debtor and creditor, before deduction of charges, expressed in the currency of the debtor's account, and to be moved in a different currency.<br/>Format: minInclusive 0,totalDigits 18,fractionDigits 5")
    public Double getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Double instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public RequestToPayInstruction chargeBearer(String chargeBearer) {
        this.chargeBearer = chargeBearer;
        return this;
    }

    @Schema(example="CRED", description="Specifies which party/parties will bear the charges associated with the processing of the payment transaction.<br/>Codeset: <br/>DEBT BorneByDebtor All transaction charges are to be borne by the debtor.<br/>CRED BorneByCreditor All transaction charges are to be borne by the creditor.<br/>SHAR Shared In a credit transfer context, means that transaction charges on the sender side are to be borne by the debtor,transaction charges on the receiver side are to be borne by the creditor. In a direct debit context, means that transaction charges on the sender side are to be borne by the creditor, transaction charges on the receiver side are to be borne by the debtor.<br/>SLEV FollowingServiceLevel Charges are to be applied following the rules agreed in the service level and/or scheme.")
    public String getChargeBearer() {
        return this.chargeBearer;
    }

    public void setChargeBearer(String chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    public RequestToPayInstruction creditorAgent(CreditorAgent creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @Schema(description="")
    public CreditorAgent getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(CreditorAgent creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public RequestToPayInstruction creditor(Creditor creditor) {
        this.creditor = creditor;
        return this;
    }

    @Schema(required=true, description="")
    public Creditor getCreditor() {
        return this.creditor;
    }

    public void setCreditor(Creditor creditor) {
        this.creditor = creditor;
    }

    public RequestToPayInstruction ultimateCreditor(UltimateCreditor ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
        return this;
    }

    @Schema(description="")
    public UltimateCreditor getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public void setUltimateCreditor(UltimateCreditor ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public RequestToPayInstruction remittanceInformation(String remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @Schema(description="Information supplied to enable the matching/reconciliation of an entry with the items that the payment is intended to settle, such as commercial invoices in an accounts' receivable system, in an unstructured form.")
    public String getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(String remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public RequestToPayInstruction additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @Schema(description="Additional information supplied to enable matching")
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestToPayInstruction requestToPayInstruction = (RequestToPayInstruction)o;
        return Objects.equals(this.endToEndId, requestToPayInstruction.endToEndId) && Objects.equals(this.paymentMethod, requestToPayInstruction.paymentMethod) && Objects.equals(this.requestedExecutionDatetime, requestToPayInstruction.requestedExecutionDatetime) && Objects.equals(this.initiatingParty, requestToPayInstruction.initiatingParty) && Objects.equals(this.debtor, requestToPayInstruction.debtor) && Objects.equals(this.debtorAgent, requestToPayInstruction.debtorAgent) && Objects.equals(this.ultimateDebtor, requestToPayInstruction.ultimateDebtor) && Objects.equals(this.instructedAmount, requestToPayInstruction.instructedAmount) && Objects.equals(this.chargeBearer, requestToPayInstruction.chargeBearer) && Objects.equals(this.creditorAgent, requestToPayInstruction.creditorAgent) && Objects.equals(this.creditor, requestToPayInstruction.creditor) && Objects.equals(this.ultimateCreditor, requestToPayInstruction.ultimateCreditor) && Objects.equals(this.remittanceInformation, requestToPayInstruction.remittanceInformation) && Objects.equals(this.additionalInformation, requestToPayInstruction.additionalInformation);
    }

    public int hashCode() {
        return Objects.hash(this.endToEndId, this.paymentMethod, this.requestedExecutionDatetime, this.initiatingParty, this.debtor, this.debtorAgent, this.ultimateDebtor, this.instructedAmount, this.chargeBearer, this.creditorAgent, this.creditor, this.ultimateCreditor, this.remittanceInformation, this.additionalInformation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestToPayInstruction {\n");
        sb.append("    endToEndId: ").append(this.toIndentedString(this.endToEndId)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    requestedExecutionDatetime: ").append(this.toIndentedString(this.requestedExecutionDatetime)).append("\n");
        sb.append("    initiatingParty: ").append(this.toIndentedString(this.initiatingParty)).append("\n");
        sb.append("    debtor: ").append(this.toIndentedString(this.debtor)).append("\n");
        sb.append("    debtorAgent: ").append(this.toIndentedString(this.debtorAgent)).append("\n");
        sb.append("    ultimateDebtor: ").append(this.toIndentedString(this.ultimateDebtor)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    chargeBearer: ").append(this.toIndentedString(this.chargeBearer)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditor: ").append(this.toIndentedString(this.creditor)).append("\n");
        sb.append("    ultimateCreditor: ").append(this.toIndentedString(this.ultimateCreditor)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("    additionalInformation: ").append(this.toIndentedString(this.additionalInformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

