/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mboapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Posting of an item to a cash account, in the context of a cash transaction, that results in an increase or decrease to the balance of the account.")
public class BalanceAvailableBalanceBalanceAmount
implements Serializable {
    @JsonProperty(value="amount")
    private Object amount = null;
    @JsonProperty(value="credit_debit_indicator")
    private CreditDebitIndicatorEnum creditDebitIndicator = null;

    public BalanceAvailableBalanceBalanceAmount amount(Object amount) {
        this.amount = amount;
        return this;
    }

    @Schema(example="1956.23", description="balance amount, with sign + or -")
    public Object getAmount() {
        return this.amount;
    }

    public void setAmount(Object amount) {
        this.amount = amount;
    }

    public BalanceAvailableBalanceBalanceAmount creditDebitIndicator(CreditDebitIndicatorEnum creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @Schema(example="CRDT", description="CRDT is amount is positive, DBU if negative")
    public CreditDebitIndicatorEnum getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(CreditDebitIndicatorEnum creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceAvailableBalanceBalanceAmount balanceavailableBalanceBalanceAmount = (BalanceAvailableBalanceBalanceAmount)o;
        return Objects.equals(this.amount, balanceavailableBalanceBalanceAmount.amount) && Objects.equals((Object)this.creditDebitIndicator, (Object)balanceavailableBalanceBalanceAmount.creditDebitIndicator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.creditDebitIndicator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceavailableBalanceBalanceAmount {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CreditDebitIndicatorEnum {
        CRDT("CRDT"),
        DBIT("DBIT");

        private String value;

        private CreditDebitIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CreditDebitIndicatorEnum fromValue(String input) {
            for (CreditDebitIndicatorEnum b : CreditDebitIndicatorEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CreditDebitIndicatorEnum> {
            public void write(JsonWriter jsonWriter, CreditDebitIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public CreditDebitIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CreditDebitIndicatorEnum.fromValue(value);
            }
        }
    }
}

