/* $Id: ObjectCreate.java 992750 2010-09-05 09:54:37Z simonetripodi $
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ar.apache.commons.digester.annotations.rules;

import ar.apache.commons.digester.ObjectCreateRule;
import ar.apache.commons.digester.annotations.CreationRule;
import ar.apache.commons.digester.annotations.DigesterRule;
import ar.apache.commons.digester.annotations.DigesterRuleList;
import ar.apache.commons.digester.annotations.providers.ObjectCreateRuleProvider;

import java.lang.annotation.*;

/**
 * Classes annotated with {@code ObjectCreate} will be bound with
 * {@code ObjectCreateRule} digester rule.
 *
 * @see ar.apache.commons.digester.Digester#addObjectCreate(String,Class)
 * @since 2.1
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@CreationRule
@DigesterRule(
        reflectsRule = ObjectCreateRule.class,
        providedBy = ObjectCreateRuleProvider.class
)
public @interface ObjectCreate {

    /**
     * The element matching pattern.
     *
     * @return the element matching pattern.
     */
    String pattern();

    /**
     * Defines several {@code @ObjectCreate} annotations on the same element.
     *
     * @see ObjectCreate
     */
    @Documented
    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.TYPE)
    @DigesterRuleList
    @interface List {
        ObjectCreate[] value();
    }

}
