package ar.com.sdd.mercadopago.resources;

import ar.com.sdd.mercadopago.core.MPBase;
import ar.com.sdd.mercadopago.core.MPResourceArray;
import ar.com.sdd.mercadopago.core.annotations.rest.GET;
import ar.com.sdd.mercadopago.exceptions.MPException;

/**
 * Mercado Pago SDK
 * Identification Types Array class
 *
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class IdentificationType extends MPBase {
    private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(IdentificationType .class);

    private String id = null;
    private String name = null;
    private String type = null;
    private Integer minLength = null;
    private Integer maxLength = null;


    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    public Integer getMinLength() {
        return minLength;
    }

    public Integer getMaxLength() {
        return maxLength;
    }


    public static MPResourceArray all() throws MPException {
        return all(WITHOUT_CACHE);
    }

    @GET(path="/v1/identification_types")
    public static MPResourceArray all(Boolean useCache) {
        try {
            return IdentificationType.processMethodBulk(IdentificationType.class, "all", useCache);
        } catch (MPException e) {
            e.printStackTrace();
            log.error("MPAGO:",e);
            return null;
        }
    }

}
