package ar.com.sdd.mercadopago.resources;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;


public class TokenOAuth2 implements Serializable {

    private String accessToken = null;
    private String tokenType = null;
    private Integer expiresIn = null;
    private String refreshToken = null;
    private Boolean liveMode;
    private Long userId;
    private String scope;

    public TokenOAuth2() {

    }

    /**
     * Token devuelto
     **/


    @JsonProperty("access_token")
    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * El tipo de token devuelto (Bearer)
     **/


    @JsonProperty("token_type")
    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    /**
     * Tiempo de expiración del token en minutos
     **/


    @JsonProperty("expires_in")
    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }


    @JsonProperty("refresh_token")
    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JsonProperty("live_mode")
    public Boolean getLiveMode() {
        return liveMode;
    }

    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    @JsonProperty("user_id")
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @JsonProperty("scope")
    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String toString() {
        return "TokenOAuth2 ["
                + ((accessToken != null) ? "accessToken=" + accessToken + ", " : "")
                + ((tokenType != null) ? "tokenType=" + tokenType + ", " : "")
                + ((expiresIn != null) ? "expiresIn=" + expiresIn + ", " : "")
                + ((refreshToken != null) ? "refreshToken=" + refreshToken + ", " : "")
                + ((liveMode != null) ? "liveMode=" + liveMode + ", " : "")
                + ((userId != null) ? "userId=" + userId + ", " : "")
                + ((scope != null) ? "scope=" + scope : "")
                + "]";
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TokenOAuth2 that = (TokenOAuth2) o;

        if (accessToken != null ? !accessToken.equals(that.accessToken) : that.accessToken != null) return false;
        if (tokenType != null ? !tokenType.equals(that.tokenType) : that.tokenType != null) return false;
        if (expiresIn != null ? !expiresIn.equals(that.expiresIn) : that.expiresIn != null) return false;
        if (refreshToken != null ? !refreshToken.equals(that.refreshToken) : that.refreshToken != null) return false;
        if (liveMode != null ? !liveMode.equals(that.liveMode) : that.liveMode != null) return false;
        if (userId != null ? !userId.equals(that.userId) : that.userId != null) return false;
        return scope != null ? scope.equals(that.scope) : that.scope == null;
    }

    @Override
    public int hashCode() {
        int result = accessToken != null ? accessToken.hashCode() : 0;
        result = 31 * result + (tokenType != null ? tokenType.hashCode() : 0);
        result = 31 * result + (expiresIn != null ? expiresIn.hashCode() : 0);
        result = 31 * result + (refreshToken != null ? refreshToken.hashCode() : 0);
        result = 31 * result + (liveMode != null ? liveMode.hashCode() : 0);
        result = 31 * result + (userId != null ? userId.hashCode() : 0);
        result = 31 * result + (scope != null ? scope.hashCode() : 0);
        return result;
    }
}

