/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains generic collection interfaces and implementations, and
 * other utilities for working with collections. It is a part of the open-source
 * <a href="http://guava-libraries.googlecode.com">Guava libraries</a>.
 *
 * <h2>Collection Types</h2>
 *
 * <dl>
 * <dt>{@link ar.google.common.collect.BiMap}
 * <dd>An extension of {@link java.util.Map} that guarantees the uniqueness of
 *     its values as well as that of its keys. This is sometimes called an
 *     "invertible map," since the restriction on values enables it to support
 *     an {@linkplain ar.google.common.collect.BiMap#inverse inverse view} --
 *     which is another instance of {@code BiMap}.
 *
 * <dt>{@link ar.google.common.collect.Multiset}
 * <dd>An extension of {@link java.util.Collection} that may contain duplicate
 *     values like a {@link java.util.List}, yet has order-independent equality
 *     like a {@link java.util.Set}.  One typical use for a multiset is to
 *     represent a histogram.
 *
 * <dt>{@link ar.google.common.collect.Multimap}
 * <dd>A new type, which is similar to {@link java.util.Map}, but may contain
 *     multiple entries with the same key. Some behaviors of
 *     {@link ar.google.common.collect.Multimap} are left unspecified and are
 *     provided only by the subtypes mentioned below.
 *
 * <dt>{@link ar.google.common.collect.ListMultimap}
 * <dd>An extension of {@link ar.google.common.collect.Multimap} which permits
 *     duplicate entries, supports random access of values for a particular key,
 *     and has <i>partially order-dependent equality</i> as defined by
 *     {@link ar.google.common.collect.ListMultimap#equals(Object)}. {@code
 *     ListMultimap} takes its name from the fact that the {@linkplain
 *     ar.google.common.collect.ListMultimap#get collection of values}
 *     associated with a given key fulfills the {@link java.util.List} contract.
 *
 * <dt>{@link ar.google.common.collect.SetMultimap}
 * <dd>An extension of {@link ar.google.common.collect.Multimap} which has
 *     order-independent equality and does not allow duplicate entries; that is,
 *     while a key may appear twice in a {@code SetMultimap}, each must map to a
 *     different value.  {@code SetMultimap} takes its name from the fact that
 *     the {@linkplain ar.google.common.collect.SetMultimap#get collection of
 *     values} associated with a given key fulfills the {@link java.util.Set}
 *     contract.
 *
 * <dt>{@link ar.google.common.collect.SortedSetMultimap}
 * <dd>An extension of {@link ar.google.common.collect.SetMultimap} for which
 *     the {@linkplain ar.google.common.collect.SortedSetMultimap#get
 *     collection values} associated with a given key is a
 *     {@link java.util.SortedSet}.
 *
 * <dt>{@link ar.google.common.collect.Table}
 * <dd>A new type, which is similar to {@link java.util.Map}, but which indexes
 *     its values by an ordered pair of keys, a row key and column key.
 *
 * <dt>{@link ar.google.common.collect.ClassToInstanceMap}
 * <dd>An extension of {@link java.util.Map} that associates a raw type with an
 *     instance of that type.
 * </dl>
 *
 * <h2>Collection Implementations</h2>
 *
 * <h3>of {@link java.util.List}</h3>
 * <ul>
 * <li>{@link ar.google.common.collect.ImmutableList}
 * </ul>
 *
 * <h3>of {@link java.util.Set}</h3>
 * <ul>
 * <li>{@link ar.google.common.collect.ImmutableSet}
 * <li>{@link ar.google.common.collect.ImmutableSortedSet}
 * <li>{@link ar.google.common.collect.ContiguousSet} (see {@code Range})
 * </ul>
 *
 * <h3>of {@link java.util.Map}</h3>
 * <ul>
 * <li>{@link ar.google.common.collect.ImmutableMap}
 * <li>{@link ar.google.common.collect.ImmutableSortedMap}
 * <li>{@link ar.google.common.collect.MapMaker}
 * </ul>
 *
 * <h3>of {@link ar.google.common.collect.BiMap}</h3>
 * <ul>
 * <li>{@link ar.google.common.collect.ImmutableBiMap}
 * <li>{@link ar.google.common.collect.HashBiMap}
 * <li>{@link ar.google.common.collect.EnumBiMap}
 * <li>{@link ar.google.common.collect.EnumHashBiMap}
 * </ul>
 *
 * <h3>of {@link ar.google.common.collect.Multiset}</h3>
 * <ul>
 * <li>{@link ar.google.common.collect.ImmutableMultiset}
 * <li>{@link ar.google.common.collect.HashMultiset}
 * <li>{@link ar.google.common.collect.LinkedHashMultiset}
 * <li>{@link ar.google.common.collect.TreeMultiset}
 * <li>{@link ar.google.common.collect.EnumMultiset}
 * <li>{@link ar.google.common.collect.ConcurrentHashMultiset}
 * </ul>
 *
 * <h3>of {@link ar.google.common.collect.Multimap}</h3>
 * <ul>
 * <li>{@link ar.google.common.collect.ImmutableMultimap}
 * <li>{@link ar.google.common.collect.ImmutableListMultimap}
 * <li>{@link ar.google.common.collect.ImmutableSetMultimap}
 * <li>{@link ar.google.common.collect.ArrayListMultimap}
 * <li>{@link ar.google.common.collect.HashMultimap}
 * <li>{@link ar.google.common.collect.TreeMultimap}
 * <li>{@link ar.google.common.collect.LinkedHashMultimap}
 * <li>{@link ar.google.common.collect.LinkedListMultimap}
 * </ul>
 *
 * <h3>of {@link ar.google.common.collect.Table}</h3>
 * <ul>
 * <li>{@link ar.google.common.collect.ImmutableTable}
 * <li>{@link ar.google.common.collect.ArrayTable}
 * <li>{@link ar.google.common.collect.HashBasedTable}
 * <li>{@link ar.google.common.collect.TreeBasedTable}
 * </ul>
 *
 * <h3>of {@link ar.google.common.collect.ClassToInstanceMap}</h3>
 * <ul>
 * <li>{@link ar.google.common.collect.ImmutableClassToInstanceMap}
 * <li>{@link ar.google.common.collect.MutableClassToInstanceMap}
 * </ul>
 *
 * <h2>Classes of static utility methods</h2>
 *
 * <ul>
 * <li>{@link ar.google.common.collect.Collections2}
 * <li>{@link ar.google.common.collect.Iterators}
 * <li>{@link ar.google.common.collect.Iterables}
 * <li>{@link ar.google.common.collect.Lists}
 * <li>{@link ar.google.common.collect.Maps}
 * <li>{@link ar.google.common.collect.Queues}
 * <li>{@link ar.google.common.collect.Sets}
 * <li>{@link ar.google.common.collect.Multisets}
 * <li>{@link ar.google.common.collect.Multimaps}
 * <li>{@link ar.google.common.collect.Tables}
 * <li>{@link ar.google.common.collect.ObjectArrays}
 * </ul>
 *
 * <h2>Comparison</h2>
 *
 * <ul>
 * <li>{@link ar.google.common.collect.Ordering}
 * <li>{@link ar.google.common.collect.ComparisonChain}
 * </ul>
 *
 * <h2>Abstract implementations</h2>
 *
 * <ul>
 * <li>{@link ar.google.common.collect.AbstractIterator}
 * <li>{@link ar.google.common.collect.AbstractSequentialIterator}
 * <li>{@link ar.google.common.collect.ImmutableCollection}
 * <li>{@link ar.google.common.collect.UnmodifiableIterator}
 * <li>{@link ar.google.common.collect.UnmodifiableListIterator}
 * </ul>
 *
 * <h2>Ranges</h2>
 *
 * <ul>
 * <li>{@link ar.google.common.collect.Range}
 * <li>{@link ar.google.common.collect.RangeMap}
 * <li>{@link ar.google.common.collect.DiscreteDomain}
 * <li>{@link ar.google.common.collect.ContiguousSet}
 * </ul>
 *
 * <h2>Other</h2>
 *
 * <ul>
 * <li>{@link ar.google.common.collect.Interner},
 *     {@link ar.google.common.collect.Interners}
 * <li>{@link ar.google.common.collect.Constraint},
 *     {@link ar.google.common.collect.Constraints}
 * <li>{@link ar.google.common.collect.MapConstraint},
 *     {@link ar.google.common.collect.MapConstraints}
 * <li>{@link ar.google.common.collect.MapDifference},
 *     {@link ar.google.common.collect.SortedMapDifference}
 * <li>{@link ar.google.common.collect.MinMaxPriorityQueue}
 * <li>{@link ar.google.common.collect.PeekingIterator}
 * </ul>
 *
 * <h2>Forwarding collections</h2>
 *
 * <ul>
 * <li>{@link ar.google.common.collect.ForwardingCollection}
 * <li>{@link ar.google.common.collect.ForwardingConcurrentMap}
 * <li>{@link ar.google.common.collect.ForwardingIterator}
 * <li>{@link ar.google.common.collect.ForwardingList}
 * <li>{@link ar.google.common.collect.ForwardingListIterator}
 * <li>{@link ar.google.common.collect.ForwardingListMultimap}
 * <li>{@link ar.google.common.collect.ForwardingMap}
 * <li>{@link ar.google.common.collect.ForwardingMapEntry}
 * <li>{@link ar.google.common.collect.ForwardingMultimap}
 * <li>{@link ar.google.common.collect.ForwardingMultiset}
 * <li>{@link ar.google.common.collect.ForwardingNavigableMap}
 * <li>{@link ar.google.common.collect.ForwardingNavigableSet}
 * <li>{@link ar.google.common.collect.ForwardingObject}
 * <li>{@link ar.google.common.collect.ForwardingQueue}
 * <li>{@link ar.google.common.collect.ForwardingSet}
 * <li>{@link ar.google.common.collect.ForwardingSetMultimap}
 * <li>{@link ar.google.common.collect.ForwardingSortedMap}
 * <li>{@link ar.google.common.collect.ForwardingSortedMultiset}
 * <li>{@link ar.google.common.collect.ForwardingSortedSet}
 * <li>{@link ar.google.common.collect.ForwardingSortedSetMultimap}
 * <li>{@link ar.google.common.collect.ForwardingTable}
 * </ul>
 */
@ar.annotation.ParametersAreNonnullByDefault
package ar.google.common.collect;
