/* $Id: CallMethod.java 992750 2010-09-05 09:54:37Z simonetripodi $
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ar.apache.commons.digester.annotations.rules;

import ar.apache.commons.digester.CallMethodRule;
import ar.apache.commons.digester.annotations.DigesterRule;
import ar.apache.commons.digester.annotations.DigesterRuleList;
import ar.apache.commons.digester.annotations.providers.CallMethodRuleProvider;

import java.lang.annotation.*;

/**
 * Methods annotated with {@code CallMethod} will be bound with
 * {@code CallMethodRule} digester rule.
 *
 * @see ar.apache.commons.digester.Digester#addCallMethod(String,String,int,Class[])
 * @since 2.1
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@DigesterRule(
        reflectsRule = CallMethodRule.class,
        providedBy = CallMethodRuleProvider.class
)
public @interface CallMethod {

    /**
     * The element matching pattern.
     *
     * @return the element matching pattern.
     */
    String pattern();

    /**
     * Defines several {@code @CallMethod} annotations on the same element.
     *
     * @see CallMethod
     */
    @Documented
    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.TYPE)
    @DigesterRuleList
    @interface List {
        CallMethod[] value();
    }

}
