/*
 * Decompiled with CFR 0.152.
 */
package ar.annotation;

import ar.annotation.RegEx;
import ar.annotation.meta.TypeQualifier;
import ar.annotation.meta.TypeQualifierValidator;
import ar.annotation.meta.When;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Pattern;

@Documented
@TypeQualifier(applicableTo=String.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MatchesPattern {
    @RegEx
    public String value();

    public int flags() default 0;

    public static class Checker
    implements TypeQualifierValidator<MatchesPattern> {
        @Override
        public When forConstantValue(MatchesPattern annotation, Object value) {
            Pattern p = Pattern.compile(annotation.value(), annotation.flags());
            if (p.matcher((String)value).matches()) {
                return When.ALWAYS;
            }
            return When.NEVER;
        }
    }
}

