/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.beanutils;

import ar.apache.commons.beanutils.BeanUtilsBean;
import ar.apache.commons.beanutils.ConvertUtils;
import ar.apache.commons.beanutils.Converter;
import ar.apache.commons.beanutils.WeakFastHashMap;
import ar.apache.commons.beanutils.converters.ArrayConverter;
import ar.apache.commons.beanutils.converters.BigDecimalConverter;
import ar.apache.commons.beanutils.converters.BigIntegerConverter;
import ar.apache.commons.beanutils.converters.BooleanConverter;
import ar.apache.commons.beanutils.converters.ByteConverter;
import ar.apache.commons.beanutils.converters.CalendarConverter;
import ar.apache.commons.beanutils.converters.CharacterConverter;
import ar.apache.commons.beanutils.converters.ClassConverter;
import ar.apache.commons.beanutils.converters.ConverterFacade;
import ar.apache.commons.beanutils.converters.DateConverter;
import ar.apache.commons.beanutils.converters.DoubleConverter;
import ar.apache.commons.beanutils.converters.FileConverter;
import ar.apache.commons.beanutils.converters.FloatConverter;
import ar.apache.commons.beanutils.converters.IntegerConverter;
import ar.apache.commons.beanutils.converters.LongConverter;
import ar.apache.commons.beanutils.converters.ShortConverter;
import ar.apache.commons.beanutils.converters.SqlDateConverter;
import ar.apache.commons.beanutils.converters.SqlTimeConverter;
import ar.apache.commons.beanutils.converters.SqlTimestampConverter;
import ar.apache.commons.beanutils.converters.StringConverter;
import ar.apache.commons.beanutils.converters.URLConverter;
import ar.apache.commons.logging.Log;
import ar.apache.commons.logging.LogFactory;
import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;

public class ConvertUtilsBean {
    private static final Integer ZERO = new Integer(0);
    private static final Character SPACE = new Character(' ');
    private WeakFastHashMap converters = new WeakFastHashMap();
    private Log log = LogFactory.getLog(ConvertUtils.class);
    private Boolean defaultBoolean = Boolean.FALSE;
    private Byte defaultByte = new Byte(0);
    private Character defaultCharacter = new Character(' ');
    private Double defaultDouble = new Double(0.0);
    private Float defaultFloat = new Float(0.0f);
    private Integer defaultInteger = new Integer(0);
    private Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);

    protected static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        this.converters.setFast(false);
        this.deregister();
        this.converters.setFast(true);
    }

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(boolean newDefaultBoolean) {
        this.defaultBoolean = newDefaultBoolean ? Boolean.TRUE : Boolean.FALSE;
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.TYPE);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.class);
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public void setDefaultByte(byte newDefaultByte) {
        this.defaultByte = new Byte(newDefaultByte);
        this.register(new ByteConverter(this.defaultByte), Byte.TYPE);
        this.register(new ByteConverter(this.defaultByte), Byte.class);
    }

    public char getDefaultCharacter() {
        return this.defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char newDefaultCharacter) {
        this.defaultCharacter = new Character(newDefaultCharacter);
        this.register(new CharacterConverter(this.defaultCharacter), Character.TYPE);
        this.register(new CharacterConverter(this.defaultCharacter), Character.class);
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public void setDefaultDouble(double newDefaultDouble) {
        this.defaultDouble = new Double(newDefaultDouble);
        this.register(new DoubleConverter(this.defaultDouble), Double.TYPE);
        this.register(new DoubleConverter(this.defaultDouble), Double.class);
    }

    public float getDefaultFloat() {
        return this.defaultFloat.floatValue();
    }

    public void setDefaultFloat(float newDefaultFloat) {
        this.defaultFloat = new Float(newDefaultFloat);
        this.register(new FloatConverter(this.defaultFloat), Float.TYPE);
        this.register(new FloatConverter(this.defaultFloat), Float.class);
    }

    public int getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(int newDefaultInteger) {
        this.defaultInteger = new Integer(newDefaultInteger);
        this.register(new IntegerConverter(this.defaultInteger), Integer.TYPE);
        this.register(new IntegerConverter(this.defaultInteger), Integer.class);
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public void setDefaultLong(long newDefaultLong) {
        this.defaultLong = new Long(newDefaultLong);
        this.register(new LongConverter(this.defaultLong), Long.TYPE);
        this.register(new LongConverter(this.defaultLong), Long.class);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short newDefaultShort) {
        defaultShort = new Short(newDefaultShort);
        this.register(new ShortConverter(defaultShort), Short.TYPE);
        this.register(new ShortConverter(defaultShort), Short.class);
    }

    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) < 1) {
                return null;
            }
            if ((value = Array.get(value, 0)) == null) {
                return null;
            }
            Converter converter = this.lookup(String.class);
            return (String)converter.convert(String.class, value);
        }
        Converter converter = this.lookup(String.class);
        return (String)converter.convert(String.class, value);
    }

    public Object convert(String value, Class clazz) {
        Converter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert string '" + value + "' to class '" + clazz.getName() + "'");
        }
        if ((converter = this.lookup(clazz)) == null) {
            converter = this.lookup(String.class);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, value);
    }

    public Object convert(String[] values, Class clazz) {
        Converter converter;
        Class<?> type2 = clazz;
        if (clazz.isArray()) {
            type2 = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert String[" + values.length + "] to class '" + type2.getName() + "[]'");
        }
        if ((converter = this.lookup(type2)) == null) {
            converter = this.lookup(String.class);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        Object array = Array.newInstance(type2, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, converter.convert(type2, values[i]));
        }
        return array;
    }

    public Object convert(Object value, Class targetType) {
        Class<?> sourceType;
        Class<?> clazz = sourceType = value == null ? null : value.getClass();
        if (this.log.isDebugEnabled()) {
            if (value == null) {
                this.log.debug("Convert null value to type '" + targetType.getName() + "'");
            } else {
                this.log.debug("Convert type '" + sourceType.getName() + "' value '" + value + "' to type '" + targetType.getName() + "'");
            }
        }
        Object converted = value;
        Converter converter = this.lookup(sourceType, targetType);
        if (converter != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("  Using converter " + converter);
            }
            converted = converter.convert(targetType, value);
        }
        if (targetType == String.class && converted != null && !(converted instanceof String)) {
            converter = this.lookup(String.class);
            if (converter != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("  Using converter " + converter);
                }
                converted = converter.convert(String.class, converted);
            }
            if (converted != null && !(converted instanceof String)) {
                converted = converted.toString();
            }
        }
        return converted;
    }

    public void deregister() {
        this.converters.clear();
        this.registerPrimitives(false);
        this.registerStandard(false, false);
        this.registerOther(true);
        this.registerArrays(false, 0);
        this.register(BigDecimal.class, new BigDecimalConverter());
        this.register(BigInteger.class, new BigIntegerConverter());
    }

    public void register(boolean throwException, boolean defaultNull, int defaultArraySize) {
        this.registerPrimitives(throwException);
        this.registerStandard(throwException, defaultNull);
        this.registerOther(throwException);
        this.registerArrays(throwException, defaultArraySize);
    }

    private void registerPrimitives(boolean throwException) {
        this.register(Boolean.TYPE, throwException ? new BooleanConverter() : new BooleanConverter(Boolean.FALSE));
        this.register(Byte.TYPE, throwException ? new ByteConverter() : new ByteConverter(ZERO));
        this.register(Character.TYPE, throwException ? new CharacterConverter() : new CharacterConverter(SPACE));
        this.register(Double.TYPE, throwException ? new DoubleConverter() : new DoubleConverter(ZERO));
        this.register(Float.TYPE, throwException ? new FloatConverter() : new FloatConverter(ZERO));
        this.register(Integer.TYPE, throwException ? new IntegerConverter() : new IntegerConverter(ZERO));
        this.register(Long.TYPE, throwException ? new LongConverter() : new LongConverter(ZERO));
        this.register(Short.TYPE, throwException ? new ShortConverter() : new ShortConverter(ZERO));
    }

    private void registerStandard(boolean throwException, boolean defaultNull) {
        Integer defaultNumber = defaultNull ? null : ZERO;
        BigDecimal bigDecDeflt = defaultNull ? null : new BigDecimal("0.0");
        BigInteger bigIntDeflt = defaultNull ? null : new BigInteger("0");
        Boolean booleanDefault = defaultNull ? null : Boolean.FALSE;
        Character charDefault = defaultNull ? null : SPACE;
        String stringDefault = defaultNull ? null : "";
        this.register(BigDecimal.class, throwException ? new BigDecimalConverter() : new BigDecimalConverter(bigDecDeflt));
        this.register(BigInteger.class, throwException ? new BigIntegerConverter() : new BigIntegerConverter(bigIntDeflt));
        this.register(Boolean.class, throwException ? new BooleanConverter() : new BooleanConverter(booleanDefault));
        this.register(Byte.class, throwException ? new ByteConverter() : new ByteConverter(defaultNumber));
        this.register(Character.class, throwException ? new CharacterConverter() : new CharacterConverter(charDefault));
        this.register(Double.class, throwException ? new DoubleConverter() : new DoubleConverter(defaultNumber));
        this.register(Float.class, throwException ? new FloatConverter() : new FloatConverter(defaultNumber));
        this.register(Integer.class, throwException ? new IntegerConverter() : new IntegerConverter(defaultNumber));
        this.register(Long.class, throwException ? new LongConverter() : new LongConverter(defaultNumber));
        this.register(Short.class, throwException ? new ShortConverter() : new ShortConverter(defaultNumber));
        this.register(String.class, throwException ? new StringConverter() : new StringConverter(stringDefault));
    }

    private void registerOther(boolean throwException) {
        this.register(Class.class, throwException ? new ClassConverter() : new ClassConverter(null));
        this.register(java.util.Date.class, throwException ? new DateConverter() : new DateConverter(null));
        this.register(Calendar.class, throwException ? new CalendarConverter() : new CalendarConverter(null));
        this.register(File.class, throwException ? new FileConverter() : new FileConverter(null));
        this.register(Date.class, throwException ? new SqlDateConverter() : new SqlDateConverter(null));
        this.register(Time.class, throwException ? new SqlTimeConverter() : new SqlTimeConverter(null));
        this.register(Timestamp.class, throwException ? new SqlTimestampConverter() : new SqlTimestampConverter(null));
        this.register(URL.class, throwException ? new URLConverter() : new URLConverter(null));
    }

    private void registerArrays(boolean throwException, int defaultArraySize) {
        this.registerArrayConverter(Boolean.TYPE, new BooleanConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Byte.TYPE, new ByteConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Character.TYPE, new CharacterConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Double.TYPE, new DoubleConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Float.TYPE, new FloatConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Integer.TYPE, new IntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Long.TYPE, new LongConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Short.TYPE, new ShortConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(BigDecimal.class, new BigDecimalConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(BigInteger.class, new BigIntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Boolean.class, new BooleanConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Byte.class, new ByteConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Character.class, new CharacterConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Double.class, new DoubleConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Float.class, new FloatConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Integer.class, new IntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Long.class, new LongConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Short.class, new ShortConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(String.class, new StringConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Class.class, new ClassConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(java.util.Date.class, new DateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Calendar.class, new DateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(File.class, new FileConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Date.class, new SqlDateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Time.class, new SqlTimeConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Timestamp.class, new SqlTimestampConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(URL.class, new URLConverter(), throwException, defaultArraySize);
    }

    private void registerArrayConverter(Class componentType, Converter componentConverter, boolean throwException, int defaultArraySize) {
        Class<?> arrayType = Array.newInstance(componentType, 0).getClass();
        ArrayConverter arrayConverter = null;
        arrayConverter = throwException ? new ArrayConverter(arrayType, componentConverter) : new ArrayConverter(arrayType, componentConverter, defaultArraySize);
        this.register(arrayType, arrayConverter);
    }

    private void register(Class clazz, Converter converter) {
        this.register(new ConverterFacade(converter), clazz);
    }

    public void deregister(Class clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class clazz) {
        return (Converter)this.converters.get(clazz);
    }

    public Converter lookup(Class sourceType, Class targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("Target type is missing");
        }
        if (sourceType == null) {
            return this.lookup(targetType);
        }
        Converter converter = null;
        if (targetType == String.class) {
            converter = this.lookup(sourceType);
            if (converter == null && (sourceType.isArray() || Collection.class.isAssignableFrom(sourceType))) {
                converter = this.lookup(String[].class);
            }
            if (converter == null) {
                converter = this.lookup(String.class);
            }
            return converter;
        }
        if (targetType == String[].class) {
            if (sourceType.isArray() || Collection.class.isAssignableFrom(sourceType)) {
                converter = this.lookup(sourceType);
            }
            if (converter == null) {
                converter = this.lookup(String[].class);
            }
            return converter;
        }
        return this.lookup(targetType);
    }

    public void register(Converter converter, Class clazz) {
        this.converters.put(clazz, converter);
    }
}

