/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.beanutils.converters;

import ar.apache.commons.beanutils.BeanUtils;
import ar.apache.commons.beanutils.ConversionException;
import ar.apache.commons.beanutils.Converter;
import ar.apache.commons.logging.Log;
import ar.apache.commons.logging.LogFactory;
import java.lang.reflect.Array;
import java.util.Collection;

public abstract class AbstractConverter
implements Converter {
    private static final String DEFAULT_CONFIG_MSG = "(N.B. Converters can be configured to use default values to avoid throwing exceptions)";
    private static final String PACKAGE = "ar.apache.commons.beanutils.converters.";
    private transient Log log;
    private boolean useDefault = false;
    private Object defaultValue = null;

    public AbstractConverter() {
    }

    public AbstractConverter(Object defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Override
    public Object convert(Class type2, Object value) {
        Class<?> sourceType = value == null ? null : value.getClass();
        Class targetType = this.primitive(type2 == null ? this.getDefaultType() : type2);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Converting" + (value == null ? "" : " '" + this.toString(sourceType) + "'") + " value '" + value + "' to type '" + this.toString(targetType) + "'");
        }
        if ((value = this.convertArray(value)) == null) {
            return this.handleMissing(targetType);
        }
        sourceType = value.getClass();
        try {
            if (targetType.equals(String.class)) {
                return this.convertToString(value);
            }
            if (targetType.equals(sourceType)) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    No conversion required, value is already a " + this.toString(targetType));
                }
                return value;
            }
            Object result = this.convertToType(targetType, value);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted to " + this.toString(targetType) + " value '" + result + "'");
            }
            return result;
        }
        catch (Throwable t) {
            return this.handleError(targetType, value, t);
        }
    }

    protected String convertToString(Object value) throws Throwable {
        return value.toString();
    }

    protected abstract Object convertToType(Class var1, Object var2) throws Throwable;

    protected Object convertArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) > 0) {
                return Array.get(value, 0);
            }
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.size() > 0) {
                return collection.iterator().next();
            }
            return null;
        }
        return value;
    }

    protected Object handleError(Class type2, Object value, Throwable cause) {
        if (this.log().isDebugEnabled()) {
            if (cause instanceof ConversionException) {
                this.log().debug("    Conversion threw ConversionException: " + cause.getMessage());
            } else {
                this.log().debug("    Conversion threw " + cause);
            }
        }
        if (this.useDefault) {
            return this.handleMissing(type2);
        }
        ConversionException cex = null;
        if (cause instanceof ConversionException) {
            cex = (ConversionException)cause;
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Re-throwing ConversionException: " + cex.getMessage());
                this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
        } else {
            String msg = "Error converting from '" + this.toString(value.getClass()) + "' to '" + this.toString(type2) + "' " + cause.getMessage();
            cex = new ConversionException(msg, cause);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Throwing ConversionException: " + msg);
                this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
            BeanUtils.initCause(cex, cause);
        }
        throw cex;
    }

    protected Object handleMissing(Class type2) {
        if (this.useDefault || type2.equals(String.class)) {
            Object value = this.getDefault(type2);
            if (this.useDefault && value != null && !type2.equals(value.getClass())) {
                try {
                    value = this.convertToType(type2, this.defaultValue);
                }
                catch (Throwable t) {
                    this.log().error("    Default conversion to " + this.toString(type2) + "failed: " + t);
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using default " + (value == null ? "" : this.toString(value.getClass()) + " ") + "value '" + this.defaultValue + "'");
            }
            return value;
        }
        ConversionException cex = new ConversionException("No value specified for '" + this.toString(type2) + "'");
        if (this.log().isDebugEnabled()) {
            this.log().debug("    Throwing ConversionException: " + cex.getMessage());
            this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
        }
        throw cex;
    }

    protected void setDefaultValue(Object defaultValue) {
        this.useDefault = false;
        if (this.log().isDebugEnabled()) {
            this.log().debug("Setting default value: " + defaultValue);
        }
        this.defaultValue = defaultValue == null ? null : this.convert(this.getDefaultType(), defaultValue);
        this.useDefault = true;
    }

    protected abstract Class getDefaultType();

    protected Object getDefault(Class type2) {
        if (type2.equals(String.class)) {
            return null;
        }
        return this.defaultValue;
    }

    public String toString() {
        return this.toString(this.getClass()) + "[UseDefault=" + this.useDefault + "]";
    }

    Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        return this.log;
    }

    Class primitive(Class type2) {
        if (type2 == null || !type2.isPrimitive()) {
            return type2;
        }
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        return type2;
    }

    String toString(Class type2) {
        String typeName = null;
        if (type2 == null) {
            typeName = "null";
        } else if (type2.isArray()) {
            Class<?> elementType = type2.getComponentType();
            int count = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count;
            }
            typeName = elementType.getName();
            for (int i = 0; i < count; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type2.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(PACKAGE.length());
        }
        return typeName;
    }
}

