/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.beanutils.converters;

import ar.apache.commons.beanutils.ConversionException;
import ar.apache.commons.beanutils.converters.AbstractArrayConverter;
import java.util.List;

public final class IntegerArrayConverter
extends AbstractArrayConverter {
    private static final int[] MODEL = new int[0];

    public IntegerArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public IntegerArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class type2, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (MODEL.getClass() == value.getClass()) {
            return value;
        }
        if (strings.getClass() == value.getClass()) {
            try {
                String[] values = (String[])value;
                int[] results = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = Integer.parseInt(values[i]);
                }
                return results;
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value.toString(), e);
            }
        }
        try {
            List list = this.parseElements(value.toString());
            int[] results = new int[list.size()];
            for (int i = 0; i < results.length; ++i) {
                results[i] = Integer.parseInt((String)list.get(i));
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value.toString(), e);
        }
    }
}

