/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.collections;

import ar.apache.commons.collections.ArrayStack;
import ar.apache.commons.collections.Buffer;
import ar.apache.commons.collections.Predicate;
import ar.apache.commons.collections.Transformer;
import ar.apache.commons.collections.buffer.BlockingBuffer;
import ar.apache.commons.collections.buffer.BoundedBuffer;
import ar.apache.commons.collections.buffer.PredicatedBuffer;
import ar.apache.commons.collections.buffer.SynchronizedBuffer;
import ar.apache.commons.collections.buffer.TransformedBuffer;
import ar.apache.commons.collections.buffer.TypedBuffer;
import ar.apache.commons.collections.buffer.UnmodifiableBuffer;

public class BufferUtils {
    public static final Buffer EMPTY_BUFFER = UnmodifiableBuffer.decorate(new ArrayStack(1));

    public static Buffer synchronizedBuffer(Buffer buffer) {
        return SynchronizedBuffer.decorate(buffer);
    }

    public static Buffer blockingBuffer(Buffer buffer) {
        return BlockingBuffer.decorate(buffer);
    }

    public static Buffer blockingBuffer(Buffer buffer, long timeoutMillis) {
        return BlockingBuffer.decorate(buffer, timeoutMillis);
    }

    public static Buffer boundedBuffer(Buffer buffer, int maximumSize) {
        return BoundedBuffer.decorate(buffer, maximumSize);
    }

    public static Buffer boundedBuffer(Buffer buffer, int maximumSize, long timeoutMillis) {
        return BoundedBuffer.decorate(buffer, maximumSize, timeoutMillis);
    }

    public static Buffer unmodifiableBuffer(Buffer buffer) {
        return UnmodifiableBuffer.decorate(buffer);
    }

    public static Buffer predicatedBuffer(Buffer buffer, Predicate predicate) {
        return PredicatedBuffer.decorate(buffer, predicate);
    }

    public static Buffer typedBuffer(Buffer buffer, Class type2) {
        return TypedBuffer.decorate(buffer, type2);
    }

    public static Buffer transformedBuffer(Buffer buffer, Transformer transformer) {
        return TransformedBuffer.decorate(buffer, transformer);
    }
}

