/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.collections.iterators;

import ar.apache.commons.collections.ResettableListIterator;
import java.util.List;
import java.util.ListIterator;

public class ReverseListIterator
implements ResettableListIterator {
    private final List list;
    private ListIterator iterator;
    private boolean validForUpdate = true;

    public ReverseListIterator(List list) {
        this.list = list;
        this.iterator = list.listIterator(list.size());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasPrevious();
    }

    public Object next() {
        Object obj = this.iterator.previous();
        this.validForUpdate = true;
        return obj;
    }

    @Override
    public int nextIndex() {
        return this.iterator.previousIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasNext();
    }

    public Object previous() {
        Object obj = this.iterator.next();
        this.validForUpdate = true;
        return obj;
    }

    @Override
    public int previousIndex() {
        return this.iterator.nextIndex();
    }

    @Override
    public void remove() {
        if (!this.validForUpdate) {
            throw new IllegalStateException("Cannot remove from list until next() or previous() called");
        }
        this.iterator.remove();
    }

    public void set(Object obj) {
        if (!this.validForUpdate) {
            throw new IllegalStateException("Cannot set to list until next() or previous() called");
        }
        this.iterator.set(obj);
    }

    public void add(Object obj) {
        if (!this.validForUpdate) {
            throw new IllegalStateException("Cannot add to list until next() or previous() called");
        }
        this.validForUpdate = false;
        this.iterator.add(obj);
        this.iterator.previous();
    }

    @Override
    public void reset() {
        this.iterator = this.list.listIterator(this.list.size());
    }
}

