/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.digester.annotations.handlers;

import ar.apache.commons.digester.Rule;
import ar.apache.commons.digester.annotations.AnnotationRuleProvider;
import ar.apache.commons.digester.annotations.CreationRule;
import ar.apache.commons.digester.annotations.DigesterLoaderHandler;
import ar.apache.commons.digester.annotations.DigesterLoadingException;
import ar.apache.commons.digester.annotations.DigesterRule;
import ar.apache.commons.digester.annotations.DigesterRuleList;
import ar.apache.commons.digester.annotations.FromAnnotationsRuleSet;
import ar.apache.commons.digester.annotations.utils.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class MethodHandler
implements DigesterLoaderHandler<Annotation, Method> {
    private static final int SUPPORTED_ARGS = 1;

    @Override
    public void handle(Annotation annotation, Method element, FromAnnotationsRuleSet ruleSet) {
        if (1 != element.getParameterTypes().length) {
            DigesterRule rule = annotation.annotationType().getAnnotation(DigesterRule.class);
            throw new DigesterLoadingException("Methods annotated with digester annotation rule @" + rule.reflectsRule().getName() + " must have just one argument");
        }
        Object explicitTypesObject = AnnotationUtils.getAnnotationValue(annotation);
        if (explicitTypesObject == null || !explicitTypesObject.getClass().isArray() || Class.class != explicitTypesObject.getClass().getComponentType()) {
            throw new DigesterLoadingException("Impossible to apply this handler, @" + annotation.getClass().getName() + ".value() has to be of type 'Class<?>[]'");
        }
        Class[] explicitTypes = (Class[])explicitTypesObject;
        Class<?> paramType = element.getParameterTypes()[0];
        if (explicitTypes.length > 0) {
            for (Class explicitType : explicitTypes) {
                if (!paramType.isAssignableFrom(explicitType)) {
                    throw new DigesterLoadingException("Impossible to handle annotation " + annotation + " on method " + element.toGenericString() + ", " + explicitType.getName() + " has to be a " + paramType.getName());
                }
                this.doHandle(annotation, element, explicitType, ruleSet);
            }
        } else {
            this.doHandle(annotation, element, paramType, ruleSet);
        }
    }

    private void doHandle(Annotation methodAnnotation, Method method, Class<?> type2, FromAnnotationsRuleSet ruleSet) {
        if (type2.isInterface() && Modifier.isAbstract(type2.getModifiers())) {
            throw new DigesterLoadingException("Impossible to proceed analyzing " + methodAnnotation + ", specified type '" + type2.getName() + "' is an interface/abstract");
        }
        for (Annotation annotation : type2.getAnnotations()) {
            this.doHandle(methodAnnotation, annotation, method, type2, ruleSet);
        }
    }

    private <A extends Annotation, R extends Rule> void doHandle(A methodAnnotation, Annotation annotation, Method method, Class<?> type2, FromAnnotationsRuleSet ruleSet) {
        Annotation[] annotations;
        if (annotation.annotationType().isAnnotationPresent(DigesterRule.class) && annotation.annotationType().isAnnotationPresent(CreationRule.class)) {
            ruleSet.addRules(type2);
            DigesterRule digesterRule = methodAnnotation.annotationType().getAnnotation(DigesterRule.class);
            Class<? extends AnnotationRuleProvider<? extends Annotation, ? extends AnnotatedElement, ? extends Rule>> providerType = digesterRule.providedBy();
            ruleSet.addRuleProvider(AnnotationUtils.getAnnotationPattern(annotation), providerType, methodAnnotation, method);
        } else if (annotation.annotationType().isAnnotationPresent(DigesterRuleList.class) && (annotations = AnnotationUtils.getAnnotationsArrayValue(annotation)) != null) {
            for (Annotation ptr : annotations) {
                this.doHandle(methodAnnotation, ptr, method, type2, ruleSet);
            }
        }
    }
}

