/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.lang.enums;

import ar.apache.commons.lang.ClassUtils;
import ar.apache.commons.lang.enums.Enum8;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class ValuedEnum
extends Enum8 {
    private static final long serialVersionUID = -7129650521543789085L;
    private final int iValue;

    protected ValuedEnum(String name, int value) {
        super(name);
        this.iValue = value;
    }

    protected static Enum8 getEnum(Class enumClass, int value) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = Enum8.getEnumList(enumClass);
        for (ValuedEnum enumeration : list) {
            if (enumeration.getValue() != value) continue;
            return enumeration;
        }
        return null;
    }

    public final int getValue() {
        return this.iValue;
    }

    @Override
    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (other.getClass() != this.getClass()) {
            if (other.getClass().getName().equals(this.getClass().getName())) {
                return this.iValue - this.getValueInOtherClassLoader(other);
            }
            throw new ClassCastException("Different enum class '" + ClassUtils.getShortClassName(other.getClass()) + "'");
        }
        return this.iValue - ((ValuedEnum)other).iValue;
    }

    private int getValueInOtherClassLoader(Object other) {
        try {
            Method mth = other.getClass().getMethod("getValue", null);
            Integer value = (Integer)mth.invoke(other, null);
            return value;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new IllegalStateException("This should not happen");
    }

    @Override
    public String toString() {
        if (this.iToString == null) {
            String shortName = ClassUtils.getShortClassName(this.getEnumClass());
            this.iToString = shortName + "[" + this.getName() + "=" + this.getValue() + "]";
        }
        return this.iToString;
    }
}

