/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.client.entity;

import ar.apache.http.Header;
import ar.apache.http.HttpEntity;
import ar.apache.http.client.entity.InputStreamFactory;
import ar.apache.http.client.entity.LazyDecompressingInputStream;
import ar.apache.http.entity.HttpEntityWrapper;
import ar.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DecompressingEntity
extends HttpEntityWrapper {
    private static final int BUFFER_SIZE = 2048;
    private final InputStreamFactory inputStreamFactory;
    private InputStream content;

    public DecompressingEntity(HttpEntity wrapped, InputStreamFactory inputStreamFactory) {
        super(wrapped);
        this.inputStreamFactory = inputStreamFactory;
    }

    private InputStream getDecompressingStream() {
        InputStream in = null;
        try {
            in = this.wrappedEntity.getContent();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new LazyDecompressingInputStream(in, this.inputStreamFactory);
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.wrappedEntity.isStreaming()) {
            if (this.content == null) {
                this.content = this.getDecompressingStream();
            }
            return this.content;
        }
        return this.getDecompressingStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull(outstream, "Output stream");
        try (InputStream instream = this.getContent();){
            int l;
            byte[] buffer = new byte[2048];
            while ((l = instream.read(buffer)) != -1) {
                outstream.write(buffer, 0, l);
            }
        }
    }

    @Override
    public Header getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }
}

