/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.client.protocol;

import ar.apache.http.HttpException;
import ar.apache.http.HttpRequest;
import ar.apache.http.HttpRequestInterceptor;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.client.config.RequestConfig;
import ar.apache.http.client.protocol.HttpClientContext;
import ar.apache.http.protocol.HttpContext;
import java.util.List;

@Immutable
public class RequestAcceptEncoding
implements HttpRequestInterceptor {
    private final String acceptEncoding;

    public RequestAcceptEncoding(List<String> encodings) {
        if (encodings != null && !encodings.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < encodings.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(encodings.get(i));
            }
            this.acceptEncoding = buf.toString();
        } else {
            this.acceptEncoding = "gzip,deflate";
        }
    }

    public RequestAcceptEncoding() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (!request.containsHeader("Accept-Encoding") && requestConfig.isContentCompressionEnabled()) {
            request.addHeader("Accept-Encoding", this.acceptEncoding);
        }
    }
}

