/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.conn.util;

import ar.apache.http.annotation.Immutable;
import ar.apache.http.conn.util.DomainType;
import ar.apache.http.util.Args;
import java.util.Collections;
import java.util.List;

@Immutable
public final class PublicSuffixList {
    private final DomainType type;
    private final List<String> rules;
    private final List<String> exceptions;

    public PublicSuffixList(DomainType type2, List<String> rules, List<String> exceptions) {
        this.type = Args.notNull(type2, "Domain type");
        this.rules = Collections.unmodifiableList(Args.notNull(rules, "Domain suffix rules"));
        this.exceptions = Collections.unmodifiableList(exceptions != null ? exceptions : Collections.emptyList());
    }

    public PublicSuffixList(List<String> rules, List<String> exceptions) {
        this(DomainType.UNKNOWN, rules, exceptions);
    }

    public DomainType getType() {
        return this.type;
    }

    public List<String> getRules() {
        return this.rules;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }
}

